package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegionalConfiguration(
    replicationGroupId: String,
    replicationGroupRegion: String,
    reshardingConfiguration: Iterable[
      zio.aws.elasticache.model.ReshardingConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.RegionalConfiguration = {
    import RegionalConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.RegionalConfiguration
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .replicationGroupRegion(replicationGroupRegion: java.lang.String)
      .reshardingConfiguration(reshardingConfiguration.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.RegionalConfiguration.ReadOnly =
    zio.aws.elasticache.model.RegionalConfiguration.wrap(buildAwsValue())
}
object RegionalConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.RegionalConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.RegionalConfiguration =
      zio.aws.elasticache.model.RegionalConfiguration(
        replicationGroupId,
        replicationGroupRegion,
        reshardingConfiguration.map { item =>
          item.asEditable
        }
      )
    def replicationGroupId: String
    def replicationGroupRegion: String
    def reshardingConfiguration
        : List[zio.aws.elasticache.model.ReshardingConfiguration.ReadOnly]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getReplicationGroupRegion: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupRegion)
    def getReshardingConfiguration: ZIO[Any, Nothing, List[
      zio.aws.elasticache.model.ReshardingConfiguration.ReadOnly
    ]] = ZIO.succeed(reshardingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.RegionalConfiguration
  ) extends zio.aws.elasticache.model.RegionalConfiguration.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val replicationGroupRegion: String =
      impl.replicationGroupRegion(): String
    override val reshardingConfiguration
        : List[zio.aws.elasticache.model.ReshardingConfiguration.ReadOnly] =
      impl
        .reshardingConfiguration()
        .asScala
        .map { item =>
          zio.aws.elasticache.model.ReshardingConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.RegionalConfiguration
  ): zio.aws.elasticache.model.RegionalConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
