package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteUserGroupRequest(userGroupId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteUserGroupRequest = {
    import DeleteUserGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteUserGroupRequest
      .builder()
      .userGroupId(userGroupId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DeleteUserGroupRequest.ReadOnly =
    zio.aws.elasticache.model.DeleteUserGroupRequest.wrap(buildAwsValue())
}
object DeleteUserGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteUserGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteUserGroupRequest =
      zio.aws.elasticache.model.DeleteUserGroupRequest(userGroupId)
    def userGroupId: String
    def getUserGroupId: ZIO[Any, Nothing, String] = ZIO.succeed(userGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteUserGroupRequest
  ) extends zio.aws.elasticache.model.DeleteUserGroupRequest.ReadOnly {
    override val userGroupId: String = impl.userGroupId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteUserGroupRequest
  ): zio.aws.elasticache.model.DeleteUserGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
