package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSnapshotRequest(snapshotName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest = {
    import DeleteSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest
      .builder()
      .snapshotName(snapshotName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DeleteSnapshotRequest.ReadOnly =
    zio.aws.elasticache.model.DeleteSnapshotRequest.wrap(buildAwsValue())
}
object DeleteSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteSnapshotRequest =
      zio.aws.elasticache.model.DeleteSnapshotRequest(snapshotName)
    def snapshotName: String
    def getSnapshotName: ZIO[Any, Nothing, String] = ZIO.succeed(snapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest
  ) extends zio.aws.elasticache.model.DeleteSnapshotRequest.ReadOnly {
    override val snapshotName: String = impl.snapshotName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteSnapshotRequest
  ): zio.aws.elasticache.model.DeleteSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
