package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateCacheClusterRequest(
    cacheClusterId: String,
    replicationGroupId: Optional[String] = Optional.Absent,
    azMode: Optional[zio.aws.elasticache.model.AZMode] = Optional.Absent,
    preferredAvailabilityZone: Optional[String] = Optional.Absent,
    preferredAvailabilityZones: Optional[Iterable[String]] = Optional.Absent,
    numCacheNodes: Optional[IntegerOptional] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    cacheParameterGroupName: Optional[String] = Optional.Absent,
    cacheSubnetGroupName: Optional[String] = Optional.Absent,
    cacheSecurityGroupNames: Optional[Iterable[String]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.elasticache.model.Tag]] = Optional.Absent,
    snapshotArns: Optional[Iterable[String]] = Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    notificationTopicArn: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    snapshotRetentionLimit: Optional[IntegerOptional] = Optional.Absent,
    snapshotWindow: Optional[String] = Optional.Absent,
    authToken: Optional[String] = Optional.Absent,
    outpostMode: Optional[zio.aws.elasticache.model.OutpostMode] =
      Optional.Absent,
    preferredOutpostArn: Optional[String] = Optional.Absent,
    preferredOutpostArns: Optional[Iterable[String]] = Optional.Absent,
    logDeliveryConfigurations: Optional[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfigurationRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest = {
    import CreateCacheClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest
      .builder()
      .cacheClusterId(cacheClusterId: java.lang.String)
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(azMode.map(value => value.unwrap))(_.azMode)
      .optionallyWith(
        preferredAvailabilityZone.map(value => value: java.lang.String)
      )(_.preferredAvailabilityZone)
      .optionallyWith(
        preferredAvailabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.preferredAvailabilityZones)
      .optionallyWith(numCacheNodes.map(value => value: Integer))(
        _.numCacheNodes
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(
        cacheSecurityGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheSecurityGroupNames)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        snapshotArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotArns)
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(authToken.map(value => value: java.lang.String))(
        _.authToken
      )
      .optionallyWith(outpostMode.map(value => value.unwrap))(_.outpostMode)
      .optionallyWith(
        preferredOutpostArn.map(value => value: java.lang.String)
      )(_.preferredOutpostArn)
      .optionallyWith(
        preferredOutpostArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.preferredOutpostArns)
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CreateCacheClusterRequest.ReadOnly =
    zio.aws.elasticache.model.CreateCacheClusterRequest.wrap(buildAwsValue())
}
object CreateCacheClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateCacheClusterRequest =
      zio.aws.elasticache.model.CreateCacheClusterRequest(
        cacheClusterId,
        replicationGroupId.map(value => value),
        azMode.map(value => value),
        preferredAvailabilityZone.map(value => value),
        preferredAvailabilityZones.map(value => value),
        numCacheNodes.map(value => value),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        cacheParameterGroupName.map(value => value),
        cacheSubnetGroupName.map(value => value),
        cacheSecurityGroupNames.map(value => value),
        securityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshotArns.map(value => value),
        snapshotName.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        port.map(value => value),
        notificationTopicArn.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        authToken.map(value => value),
        outpostMode.map(value => value),
        preferredOutpostArn.map(value => value),
        preferredOutpostArns.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cacheClusterId: String
    def replicationGroupId: Optional[String]
    def azMode: Optional[zio.aws.elasticache.model.AZMode]
    def preferredAvailabilityZone: Optional[String]
    def preferredAvailabilityZones: Optional[List[String]]
    def numCacheNodes: Optional[IntegerOptional]
    def cacheNodeType: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def cacheParameterGroupName: Optional[String]
    def cacheSubnetGroupName: Optional[String]
    def cacheSecurityGroupNames: Optional[List[String]]
    def securityGroupIds: Optional[List[String]]
    def tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def snapshotArns: Optional[List[String]]
    def snapshotName: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def port: Optional[IntegerOptional]
    def notificationTopicArn: Optional[String]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def snapshotRetentionLimit: Optional[IntegerOptional]
    def snapshotWindow: Optional[String]
    def authToken: Optional[String]
    def outpostMode: Optional[zio.aws.elasticache.model.OutpostMode]
    def preferredOutpostArn: Optional[String]
    def preferredOutpostArns: Optional[List[String]]
    def logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ]
    def getCacheClusterId: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheClusterId)
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getAzMode: ZIO[Any, AwsError, zio.aws.elasticache.model.AZMode] =
      AwsError.unwrapOptionField("azMode", azMode)
    def getPreferredAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredAvailabilityZone", preferredAvailabilityZone)
    def getPreferredAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "preferredAvailabilityZones",
        preferredAvailabilityZones
      )
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getCacheSecurityGroupNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("cacheSecurityGroupNames", cacheSecurityGroupNames)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSnapshotArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("snapshotArns", snapshotArns)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAuthToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authToken", authToken)
    def getOutpostMode
        : ZIO[Any, AwsError, zio.aws.elasticache.model.OutpostMode] =
      AwsError.unwrapOptionField("outpostMode", outpostMode)
    def getPreferredOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredOutpostArn", preferredOutpostArn)
    def getPreferredOutpostArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("preferredOutpostArns", preferredOutpostArns)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest
  ) extends zio.aws.elasticache.model.CreateCacheClusterRequest.ReadOnly {
    override val cacheClusterId: String = impl.cacheClusterId(): String
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val azMode: Optional[zio.aws.elasticache.model.AZMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.azMode())
        .map(value => zio.aws.elasticache.model.AZMode.wrap(value))
    override val preferredAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredAvailabilityZone())
        .map(value => value: String)
    override val preferredAvailabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredAvailabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val numCacheNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numCacheNodes())
        .map(value => value: IntegerOptional)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val cacheParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheParameterGroupName())
        .map(value => value: String)
    override val cacheSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheSubnetGroupName())
      .map(value => value: String)
    override val cacheSecurityGroupNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheSecurityGroupNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val tags: Optional[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
    override val snapshotArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val notificationTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationTopicArn())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val snapshotRetentionLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionLimit())
        .map(value => value: IntegerOptional)
    override val snapshotWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotWindow())
      .map(value => value: String)
    override val authToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authToken())
      .map(value => value: String)
    override val outpostMode: Optional[zio.aws.elasticache.model.OutpostMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outpostMode())
        .map(value => zio.aws.elasticache.model.OutpostMode.wrap(value))
    override val preferredOutpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredOutpostArn())
      .map(value => value: String)
    override val preferredOutpostArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredOutpostArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val logDeliveryConfigurations: Optional[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfigurationRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest
  ): zio.aws.elasticache.model.CreateCacheClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
