package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCacheParameterGroupRequest(
    cacheParameterGroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest = {
    import DeleteCacheParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest
      .builder()
      .cacheParameterGroupName(cacheParameterGroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DeleteCacheParameterGroupRequest.ReadOnly =
    zio.aws.elasticache.model.DeleteCacheParameterGroupRequest
      .wrap(buildAwsValue())
}
object DeleteCacheParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteCacheParameterGroupRequest =
      zio.aws.elasticache.model
        .DeleteCacheParameterGroupRequest(cacheParameterGroupName)
    def cacheParameterGroupName: String
    def getCacheParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheParameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest
  ) extends zio.aws.elasticache.model.DeleteCacheParameterGroupRequest.ReadOnly {
    override val cacheParameterGroupName: String =
      impl.cacheParameterGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheParameterGroupRequest
  ): zio.aws.elasticache.model.DeleteCacheParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
