package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DecreaseReplicaCountRequest(
    replicationGroupId: String,
    newReplicaCount: Optional[IntegerOptional] = Optional.Absent,
    replicaConfiguration: Optional[
      Iterable[zio.aws.elasticache.model.ConfigureShard]
    ] = Optional.Absent,
    replicasToRemove: Optional[Iterable[String]] = Optional.Absent,
    applyImmediately: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest = {
    import DecreaseReplicaCountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .optionallyWith(newReplicaCount.map(value => value: Integer))(
        _.newReplicaCount
      )
      .optionallyWith(
        replicaConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaConfiguration)
      .optionallyWith(
        replicasToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicasToRemove)
      .applyImmediately(applyImmediately: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DecreaseReplicaCountRequest.ReadOnly =
    zio.aws.elasticache.model.DecreaseReplicaCountRequest.wrap(buildAwsValue())
}
object DecreaseReplicaCountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DecreaseReplicaCountRequest =
      zio.aws.elasticache.model.DecreaseReplicaCountRequest(
        replicationGroupId,
        newReplicaCount.map(value => value),
        replicaConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicasToRemove.map(value => value),
        applyImmediately
      )
    def replicationGroupId: String
    def newReplicaCount: Optional[IntegerOptional]
    def replicaConfiguration
        : Optional[List[zio.aws.elasticache.model.ConfigureShard.ReadOnly]]
    def replicasToRemove: Optional[List[String]]
    def applyImmediately: Boolean
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getNewReplicaCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("newReplicaCount", newReplicaCount)
    def getReplicaConfiguration: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ConfigureShard.ReadOnly
    ]] =
      AwsError.unwrapOptionField("replicaConfiguration", replicaConfiguration)
    def getReplicasToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicasToRemove", replicasToRemove)
    def getApplyImmediately: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(applyImmediately)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest
  ) extends zio.aws.elasticache.model.DecreaseReplicaCountRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val newReplicaCount: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newReplicaCount())
        .map(value => value: IntegerOptional)
    override val replicaConfiguration
        : Optional[List[zio.aws.elasticache.model.ConfigureShard.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaConfiguration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.ConfigureShard.wrap(item)
          }.toList
        )
    override val replicasToRemove: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicasToRemove())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val applyImmediately: Boolean = impl.applyImmediately(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest
  ): zio.aws.elasticache.model.DecreaseReplicaCountRequest.ReadOnly =
    new Wrapper(impl)
}
