package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReservedCacheNodesOfferingsRequest(
    reservedCacheNodesOfferingId: Optional[String] = Optional.Absent,
    cacheNodeType: Optional[String] = Optional.Absent,
    duration: Optional[String] = Optional.Absent,
    productDescription: Optional[String] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest = {
    import DescribeReservedCacheNodesOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
      .builder()
      .optionallyWith(
        reservedCacheNodesOfferingId.map(value => value: java.lang.String)
      )(_.reservedCacheNodesOfferingId)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(duration.map(value => value: java.lang.String))(
        _.duration
      )
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedCacheNodesOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest =
      zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest(
        reservedCacheNodesOfferingId.map(value => value),
        cacheNodeType.map(value => value),
        duration.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def reservedCacheNodesOfferingId: Optional[String]
    def cacheNodeType: Optional[String]
    def duration: Optional[String]
    def productDescription: Optional[String]
    def offeringType: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getReservedCacheNodesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedCacheNodesOfferingId",
        reservedCacheNodesOfferingId
      )
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getDuration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("duration", duration)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
  ) extends zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest.ReadOnly {
    override val reservedCacheNodesOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedCacheNodesOfferingId())
        .map(value => value: String)
    override val cacheNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeType())
      .map(value => value: String)
    override val duration: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: String)
    override val productDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productDescription())
      .map(value => value: String)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
  ): zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
