package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetCacheParameterGroupResponse(
    cacheParameterGroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse = {
    import ResetCacheParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse
      .builder()
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ResetCacheParameterGroupResponse.ReadOnly =
    zio.aws.elasticache.model.ResetCacheParameterGroupResponse
      .wrap(buildAwsValue())
}
object ResetCacheParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ResetCacheParameterGroupResponse =
      zio.aws.elasticache.model.ResetCacheParameterGroupResponse(
        cacheParameterGroupName.map(value => value)
      )
    def cacheParameterGroupName: Optional[String]
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse
  ) extends zio.aws.elasticache.model.ResetCacheParameterGroupResponse.ReadOnly {
    override val cacheParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheParameterGroupName())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ResetCacheParameterGroupResponse
  ): zio.aws.elasticache.model.ResetCacheParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
