package zio.aws.elasticache.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Authentication(
    `type`: Optional[zio.aws.elasticache.model.AuthenticationType] =
      Optional.Absent,
    passwordCount: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.Authentication = {
    import Authentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.Authentication
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(passwordCount.map(value => value: Integer))(
        _.passwordCount
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.Authentication.ReadOnly =
    zio.aws.elasticache.model.Authentication.wrap(buildAwsValue())
}
object Authentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.Authentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.Authentication =
      zio.aws.elasticache.model.Authentication(
        `type`.map(value => value),
        passwordCount.map(value => value)
      )
    def `type`: Optional[zio.aws.elasticache.model.AuthenticationType]
    def passwordCount: Optional[IntegerOptional]
    def getType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.AuthenticationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPasswordCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("passwordCount", passwordCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.Authentication
  ) extends zio.aws.elasticache.model.Authentication.ReadOnly {
    override val `type`
        : Optional[zio.aws.elasticache.model.AuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.elasticache.model.AuthenticationType.wrap(value))
    override val passwordCount: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.passwordCount())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.Authentication
  ): zio.aws.elasticache.model.Authentication.ReadOnly = new Wrapper(impl)
}
