package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGlobalReplicationGroupRequest(
    globalReplicationGroupIdSuffix: String,
    globalReplicationGroupDescription: Optional[String] = Optional.Absent,
    primaryReplicationGroupId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupRequest = {
    import CreateGlobalReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupRequest
      .builder()
      .globalReplicationGroupIdSuffix(
        globalReplicationGroupIdSuffix: java.lang.String
      )
      .optionallyWith(
        globalReplicationGroupDescription.map(value => value: java.lang.String)
      )(_.globalReplicationGroupDescription)
      .primaryReplicationGroupId(primaryReplicationGroupId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateGlobalReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.CreateGlobalReplicationGroupRequest
      .wrap(buildAwsValue())
}
object CreateGlobalReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.CreateGlobalReplicationGroupRequest =
      zio.aws.elasticache.model.CreateGlobalReplicationGroupRequest(
        globalReplicationGroupIdSuffix,
        globalReplicationGroupDescription.map(value => value),
        primaryReplicationGroupId
      )
    def globalReplicationGroupIdSuffix: String
    def globalReplicationGroupDescription: Optional[String]
    def primaryReplicationGroupId: String
    def getGlobalReplicationGroupIdSuffix: ZIO[Any, Nothing, String] =
      ZIO.succeed(globalReplicationGroupIdSuffix)
    def getGlobalReplicationGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "globalReplicationGroupDescription",
        globalReplicationGroupDescription
      )
    def getPrimaryReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(primaryReplicationGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupRequest
  ) extends zio.aws.elasticache.model.CreateGlobalReplicationGroupRequest.ReadOnly {
    override val globalReplicationGroupIdSuffix: String =
      impl.globalReplicationGroupIdSuffix(): String
    override val globalReplicationGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalReplicationGroupDescription())
        .map(value => value: String)
    override val primaryReplicationGroupId: String =
      impl.primaryReplicationGroupId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateGlobalReplicationGroupRequest
  ): zio.aws.elasticache.model.CreateGlobalReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
