package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class UpdateAction(
    replicationGroupId: Optional[String] = Optional.Absent,
    cacheClusterId: Optional[String] = Optional.Absent,
    serviceUpdateName: Optional[String] = Optional.Absent,
    serviceUpdateReleaseDate: Optional[TStamp] = Optional.Absent,
    serviceUpdateSeverity: Optional[
      zio.aws.elasticache.model.ServiceUpdateSeverity
    ] = Optional.Absent,
    serviceUpdateStatus: Optional[
      zio.aws.elasticache.model.ServiceUpdateStatus
    ] = Optional.Absent,
    serviceUpdateRecommendedApplyByDate: Optional[TStamp] = Optional.Absent,
    serviceUpdateType: Optional[zio.aws.elasticache.model.ServiceUpdateType] =
      Optional.Absent,
    updateActionAvailableDate: Optional[TStamp] = Optional.Absent,
    updateActionStatus: Optional[zio.aws.elasticache.model.UpdateActionStatus] =
      Optional.Absent,
    nodesUpdated: Optional[String] = Optional.Absent,
    updateActionStatusModifiedDate: Optional[TStamp] = Optional.Absent,
    slaMet: Optional[zio.aws.elasticache.model.SlaMet] = Optional.Absent,
    nodeGroupUpdateStatus: Optional[
      Iterable[zio.aws.elasticache.model.NodeGroupUpdateStatus]
    ] = Optional.Absent,
    cacheNodeUpdateStatus: Optional[
      Iterable[zio.aws.elasticache.model.CacheNodeUpdateStatus]
    ] = Optional.Absent,
    estimatedUpdateTime: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.UpdateAction = {
    import UpdateAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.UpdateAction
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        serviceUpdateReleaseDate.map(value => TStamp.unwrap(value): Instant)
      )(_.serviceUpdateReleaseDate)
      .optionallyWith(serviceUpdateSeverity.map(value => value.unwrap))(
        _.serviceUpdateSeverity
      )
      .optionallyWith(serviceUpdateStatus.map(value => value.unwrap))(
        _.serviceUpdateStatus
      )
      .optionallyWith(
        serviceUpdateRecommendedApplyByDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.serviceUpdateRecommendedApplyByDate)
      .optionallyWith(serviceUpdateType.map(value => value.unwrap))(
        _.serviceUpdateType
      )
      .optionallyWith(
        updateActionAvailableDate.map(value => TStamp.unwrap(value): Instant)
      )(_.updateActionAvailableDate)
      .optionallyWith(updateActionStatus.map(value => value.unwrap))(
        _.updateActionStatus
      )
      .optionallyWith(nodesUpdated.map(value => value: java.lang.String))(
        _.nodesUpdated
      )
      .optionallyWith(
        updateActionStatusModifiedDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.updateActionStatusModifiedDate)
      .optionallyWith(slaMet.map(value => value.unwrap))(_.slaMet)
      .optionallyWith(
        nodeGroupUpdateStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeGroupUpdateStatus)
      .optionallyWith(
        cacheNodeUpdateStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheNodeUpdateStatus)
      .optionallyWith(
        estimatedUpdateTime.map(value => value: java.lang.String)
      )(_.estimatedUpdateTime)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.UpdateAction.ReadOnly =
    zio.aws.elasticache.model.UpdateAction.wrap(buildAwsValue())
}
object UpdateAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.UpdateAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.UpdateAction =
      zio.aws.elasticache.model.UpdateAction(
        replicationGroupId.map(value => value),
        cacheClusterId.map(value => value),
        serviceUpdateName.map(value => value),
        serviceUpdateReleaseDate.map(value => value),
        serviceUpdateSeverity.map(value => value),
        serviceUpdateStatus.map(value => value),
        serviceUpdateRecommendedApplyByDate.map(value => value),
        serviceUpdateType.map(value => value),
        updateActionAvailableDate.map(value => value),
        updateActionStatus.map(value => value),
        nodesUpdated.map(value => value),
        updateActionStatusModifiedDate.map(value => value),
        slaMet.map(value => value),
        nodeGroupUpdateStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheNodeUpdateStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        estimatedUpdateTime.map(value => value),
        engine.map(value => value)
      )
    def replicationGroupId: Optional[String]
    def cacheClusterId: Optional[String]
    def serviceUpdateName: Optional[String]
    def serviceUpdateReleaseDate: Optional[TStamp]
    def serviceUpdateSeverity
        : Optional[zio.aws.elasticache.model.ServiceUpdateSeverity]
    def serviceUpdateStatus
        : Optional[zio.aws.elasticache.model.ServiceUpdateStatus]
    def serviceUpdateRecommendedApplyByDate: Optional[TStamp]
    def serviceUpdateType: Optional[zio.aws.elasticache.model.ServiceUpdateType]
    def updateActionAvailableDate: Optional[TStamp]
    def updateActionStatus
        : Optional[zio.aws.elasticache.model.UpdateActionStatus]
    def nodesUpdated: Optional[String]
    def updateActionStatusModifiedDate: Optional[TStamp]
    def slaMet: Optional[zio.aws.elasticache.model.SlaMet]
    def nodeGroupUpdateStatus: Optional[
      List[zio.aws.elasticache.model.NodeGroupUpdateStatus.ReadOnly]
    ]
    def cacheNodeUpdateStatus: Optional[
      List[zio.aws.elasticache.model.CacheNodeUpdateStatus.ReadOnly]
    ]
    def estimatedUpdateTime: Optional[String]
    def engine: Optional[String]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getServiceUpdateReleaseDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("serviceUpdateReleaseDate", serviceUpdateReleaseDate)
    def getServiceUpdateSeverity
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateSeverity] =
      AwsError.unwrapOptionField("serviceUpdateSeverity", serviceUpdateSeverity)
    def getServiceUpdateStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateStatus] =
      AwsError.unwrapOptionField("serviceUpdateStatus", serviceUpdateStatus)
    def getServiceUpdateRecommendedApplyByDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "serviceUpdateRecommendedApplyByDate",
        serviceUpdateRecommendedApplyByDate
      )
    def getServiceUpdateType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateType] =
      AwsError.unwrapOptionField("serviceUpdateType", serviceUpdateType)
    def getUpdateActionAvailableDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("updateActionAvailableDate", updateActionAvailableDate)
    def getUpdateActionStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.UpdateActionStatus] =
      AwsError.unwrapOptionField("updateActionStatus", updateActionStatus)
    def getNodesUpdated: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodesUpdated", nodesUpdated)
    def getUpdateActionStatusModifiedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "updateActionStatusModifiedDate",
        updateActionStatusModifiedDate
      )
    def getSlaMet: ZIO[Any, AwsError, zio.aws.elasticache.model.SlaMet] =
      AwsError.unwrapOptionField("slaMet", slaMet)
    def getNodeGroupUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeGroupUpdateStatus.ReadOnly
    ]] =
      AwsError.unwrapOptionField("nodeGroupUpdateStatus", nodeGroupUpdateStatus)
    def getCacheNodeUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheNodeUpdateStatus.ReadOnly
    ]] =
      AwsError.unwrapOptionField("cacheNodeUpdateStatus", cacheNodeUpdateStatus)
    def getEstimatedUpdateTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("estimatedUpdateTime", estimatedUpdateTime)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.UpdateAction
  ) extends zio.aws.elasticache.model.UpdateAction.ReadOnly {
    override val replicationGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationGroupId())
      .map(value => value: String)
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val serviceUpdateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceUpdateName())
      .map(value => value: String)
    override val serviceUpdateReleaseDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateReleaseDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateSeverity
        : Optional[zio.aws.elasticache.model.ServiceUpdateSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateSeverity())
        .map(value =>
          zio.aws.elasticache.model.ServiceUpdateSeverity.wrap(value)
        )
    override val serviceUpdateStatus
        : Optional[zio.aws.elasticache.model.ServiceUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateStatus())
        .map(value => zio.aws.elasticache.model.ServiceUpdateStatus.wrap(value))
    override val serviceUpdateRecommendedApplyByDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateRecommendedApplyByDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateType
        : Optional[zio.aws.elasticache.model.ServiceUpdateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceUpdateType())
        .map(value => zio.aws.elasticache.model.ServiceUpdateType.wrap(value))
    override val updateActionAvailableDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateActionAvailableDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val updateActionStatus
        : Optional[zio.aws.elasticache.model.UpdateActionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateActionStatus())
        .map(value => zio.aws.elasticache.model.UpdateActionStatus.wrap(value))
    override val nodesUpdated: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodesUpdated())
      .map(value => value: String)
    override val updateActionStatusModifiedDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateActionStatusModifiedDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val slaMet: Optional[zio.aws.elasticache.model.SlaMet] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slaMet())
        .map(value => zio.aws.elasticache.model.SlaMet.wrap(value))
    override val nodeGroupUpdateStatus: Optional[
      List[zio.aws.elasticache.model.NodeGroupUpdateStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeGroupUpdateStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.NodeGroupUpdateStatus.wrap(item)
        }.toList
      )
    override val cacheNodeUpdateStatus: Optional[
      List[zio.aws.elasticache.model.CacheNodeUpdateStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeUpdateStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheNodeUpdateStatus.wrap(item)
        }.toList
      )
    override val estimatedUpdateTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.estimatedUpdateTime())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.UpdateAction
  ): zio.aws.elasticache.model.UpdateAction.ReadOnly = new Wrapper(impl)
}
