package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogDeliveryConfigurationRequest(
    logType: Optional[zio.aws.elasticache.model.LogType] = Optional.Absent,
    destinationType: Optional[zio.aws.elasticache.model.DestinationType] =
      Optional.Absent,
    destinationDetails: Optional[zio.aws.elasticache.model.DestinationDetails] =
      Optional.Absent,
    logFormat: Optional[zio.aws.elasticache.model.LogFormat] = Optional.Absent,
    enabled: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest = {
    import LogDeliveryConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest
      .builder()
      .optionallyWith(logType.map(value => value.unwrap))(_.logType)
      .optionallyWith(destinationType.map(value => value.unwrap))(
        _.destinationType
      )
      .optionallyWith(destinationDetails.map(value => value.buildAwsValue()))(
        _.destinationDetails
      )
      .optionallyWith(logFormat.map(value => value.unwrap))(_.logFormat)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly =
    zio.aws.elasticache.model.LogDeliveryConfigurationRequest
      .wrap(buildAwsValue())
}
object LogDeliveryConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.LogDeliveryConfigurationRequest =
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest(
        logType.map(value => value),
        destinationType.map(value => value),
        destinationDetails.map(value => value.asEditable),
        logFormat.map(value => value),
        enabled.map(value => value)
      )
    def logType: Optional[zio.aws.elasticache.model.LogType]
    def destinationType: Optional[zio.aws.elasticache.model.DestinationType]
    def destinationDetails
        : Optional[zio.aws.elasticache.model.DestinationDetails.ReadOnly]
    def logFormat: Optional[zio.aws.elasticache.model.LogFormat]
    def enabled: Optional[BooleanOptional]
    def getLogType: ZIO[Any, AwsError, zio.aws.elasticache.model.LogType] =
      AwsError.unwrapOptionField("logType", logType)
    def getDestinationType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.DestinationType] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getDestinationDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.DestinationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("destinationDetails", destinationDetails)
    def getLogFormat: ZIO[Any, AwsError, zio.aws.elasticache.model.LogFormat] =
      AwsError.unwrapOptionField("logFormat", logFormat)
    def getEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest
  ) extends zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly {
    override val logType: Optional[zio.aws.elasticache.model.LogType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logType())
        .map(value => zio.aws.elasticache.model.LogType.wrap(value))
    override val destinationType
        : Optional[zio.aws.elasticache.model.DestinationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationType())
        .map(value => zio.aws.elasticache.model.DestinationType.wrap(value))
    override val destinationDetails
        : Optional[zio.aws.elasticache.model.DestinationDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationDetails())
        .map(value => zio.aws.elasticache.model.DestinationDetails.wrap(value))
    override val logFormat: Optional[zio.aws.elasticache.model.LogFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logFormat())
        .map(value => zio.aws.elasticache.model.LogFormat.wrap(value))
    override val enabled: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest
  ): zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
