package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.UserId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserGroupPendingChanges(
    userIdsToRemove: Optional[Iterable[UserId]] = Optional.Absent,
    userIdsToAdd: Optional[Iterable[UserId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.UserGroupPendingChanges = {
    import UserGroupPendingChanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.UserGroupPendingChanges
      .builder()
      .optionallyWith(
        userIdsToRemove.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIdsToRemove)
      .optionallyWith(
        userIdsToAdd.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIdsToAdd)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.UserGroupPendingChanges.ReadOnly =
    zio.aws.elasticache.model.UserGroupPendingChanges.wrap(buildAwsValue())
}
object UserGroupPendingChanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.UserGroupPendingChanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.UserGroupPendingChanges =
      zio.aws.elasticache.model.UserGroupPendingChanges(
        userIdsToRemove.map(value => value),
        userIdsToAdd.map(value => value)
      )
    def userIdsToRemove: Optional[List[UserId]]
    def userIdsToAdd: Optional[List[UserId]]
    def getUserIdsToRemove: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIdsToRemove", userIdsToRemove)
    def getUserIdsToAdd: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIdsToAdd", userIdsToAdd)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.UserGroupPendingChanges
  ) extends zio.aws.elasticache.model.UserGroupPendingChanges.ReadOnly {
    override val userIdsToRemove: Optional[List[UserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIdsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserId(item)
        }.toList
      )
    override val userIdsToAdd: Optional[List[UserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIdsToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.UserGroupPendingChanges
  ): zio.aws.elasticache.model.UserGroupPendingChanges.ReadOnly = new Wrapper(
    impl
  )
}
