package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeUpdateActionsResponse(
    marker: Optional[String] = Optional.Absent,
    updateActions: Optional[Iterable[zio.aws.elasticache.model.UpdateAction]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse = {
    import DescribeUpdateActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        updateActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updateActions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeUpdateActionsResponse
      .wrap(buildAwsValue())
}
object DescribeUpdateActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeUpdateActionsResponse =
      zio.aws.elasticache.model.DescribeUpdateActionsResponse(
        marker.map(value => value),
        updateActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def updateActions
        : Optional[List[zio.aws.elasticache.model.UpdateAction.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getUpdateActions: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.UpdateAction.ReadOnly
    ]] = AwsError.unwrapOptionField("updateActions", updateActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse
  ) extends zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val updateActions
        : Optional[List[zio.aws.elasticache.model.UpdateAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.UpdateAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse
  ): zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly =
    new Wrapper(impl)
}
