package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PendingLogDeliveryConfiguration(
    logType: Optional[zio.aws.elasticache.model.LogType] = Optional.Absent,
    destinationType: Optional[zio.aws.elasticache.model.DestinationType] =
      Optional.Absent,
    destinationDetails: Optional[zio.aws.elasticache.model.DestinationDetails] =
      Optional.Absent,
    logFormat: Optional[zio.aws.elasticache.model.LogFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration = {
    import PendingLogDeliveryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration
      .builder()
      .optionallyWith(logType.map(value => value.unwrap))(_.logType)
      .optionallyWith(destinationType.map(value => value.unwrap))(
        _.destinationType
      )
      .optionallyWith(destinationDetails.map(value => value.buildAwsValue()))(
        _.destinationDetails
      )
      .optionallyWith(logFormat.map(value => value.unwrap))(_.logFormat)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly =
    zio.aws.elasticache.model.PendingLogDeliveryConfiguration
      .wrap(buildAwsValue())
}
object PendingLogDeliveryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.PendingLogDeliveryConfiguration =
      zio.aws.elasticache.model.PendingLogDeliveryConfiguration(
        logType.map(value => value),
        destinationType.map(value => value),
        destinationDetails.map(value => value.asEditable),
        logFormat.map(value => value)
      )
    def logType: Optional[zio.aws.elasticache.model.LogType]
    def destinationType: Optional[zio.aws.elasticache.model.DestinationType]
    def destinationDetails
        : Optional[zio.aws.elasticache.model.DestinationDetails.ReadOnly]
    def logFormat: Optional[zio.aws.elasticache.model.LogFormat]
    def getLogType: ZIO[Any, AwsError, zio.aws.elasticache.model.LogType] =
      AwsError.unwrapOptionField("logType", logType)
    def getDestinationType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.DestinationType] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getDestinationDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.DestinationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("destinationDetails", destinationDetails)
    def getLogFormat: ZIO[Any, AwsError, zio.aws.elasticache.model.LogFormat] =
      AwsError.unwrapOptionField("logFormat", logFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration
  ) extends zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly {
    override val logType: Optional[zio.aws.elasticache.model.LogType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logType())
        .map(value => zio.aws.elasticache.model.LogType.wrap(value))
    override val destinationType
        : Optional[zio.aws.elasticache.model.DestinationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationType())
        .map(value => zio.aws.elasticache.model.DestinationType.wrap(value))
    override val destinationDetails
        : Optional[zio.aws.elasticache.model.DestinationDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationDetails())
        .map(value => zio.aws.elasticache.model.DestinationDetails.wrap(value))
    override val logFormat: Optional[zio.aws.elasticache.model.LogFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logFormat())
        .map(value => zio.aws.elasticache.model.LogFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration
  ): zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly =
    new Wrapper(impl)
}
