package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteReplicationGroupRequest(
    replicationGroupId: String,
    retainPrimaryCluster: Optional[BooleanOptional] = Optional.Absent,
    finalSnapshotIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest = {
    import DeleteReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .optionallyWith(
        retainPrimaryCluster.map(value => value: java.lang.Boolean)
      )(_.retainPrimaryCluster)
      .optionallyWith(
        finalSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.finalSnapshotIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DeleteReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.DeleteReplicationGroupRequest
      .wrap(buildAwsValue())
}
object DeleteReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteReplicationGroupRequest =
      zio.aws.elasticache.model.DeleteReplicationGroupRequest(
        replicationGroupId,
        retainPrimaryCluster.map(value => value),
        finalSnapshotIdentifier.map(value => value)
      )
    def replicationGroupId: String
    def retainPrimaryCluster: Optional[BooleanOptional]
    def finalSnapshotIdentifier: Optional[String]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getRetainPrimaryCluster: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("retainPrimaryCluster", retainPrimaryCluster)
    def getFinalSnapshotIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("finalSnapshotIdentifier", finalSnapshotIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest
  ) extends zio.aws.elasticache.model.DeleteReplicationGroupRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val retainPrimaryCluster: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainPrimaryCluster())
        .map(value => value: BooleanOptional)
    override val finalSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalSnapshotIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteReplicationGroupRequest
  ): zio.aws.elasticache.model.DeleteReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
