package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.UserId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyUserGroupRequest(
    userGroupId: String,
    userIdsToAdd: Optional[Iterable[UserId]] = Optional.Absent,
    userIdsToRemove: Optional[Iterable[UserId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyUserGroupRequest = {
    import ModifyUserGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyUserGroupRequest
      .builder()
      .userGroupId(userGroupId: java.lang.String)
      .optionallyWith(
        userIdsToAdd.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIdsToAdd)
      .optionallyWith(
        userIdsToRemove.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIdsToRemove)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ModifyUserGroupRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyUserGroupRequest.wrap(buildAwsValue())
}
object ModifyUserGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyUserGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyUserGroupRequest =
      zio.aws.elasticache.model.ModifyUserGroupRequest(
        userGroupId,
        userIdsToAdd.map(value => value),
        userIdsToRemove.map(value => value)
      )
    def userGroupId: String
    def userIdsToAdd: Optional[List[UserId]]
    def userIdsToRemove: Optional[List[UserId]]
    def getUserGroupId: ZIO[Any, Nothing, String] = ZIO.succeed(userGroupId)
    def getUserIdsToAdd: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIdsToAdd", userIdsToAdd)
    def getUserIdsToRemove: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIdsToRemove", userIdsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserGroupRequest
  ) extends zio.aws.elasticache.model.ModifyUserGroupRequest.ReadOnly {
    override val userGroupId: String = impl.userGroupId(): String
    override val userIdsToAdd: Optional[List[UserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIdsToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserId(item)
        }.toList
      )
    override val userIdsToRemove: Optional[List[UserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIdsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserGroupRequest
  ): zio.aws.elasticache.model.ModifyUserGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
