package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateGlobalReplicationGroupRequest(
    globalReplicationGroupId: String,
    replicationGroupId: String,
    replicationGroupRegion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupRequest = {
    import DisassociateGlobalReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupRequest
      .builder()
      .globalReplicationGroupId(globalReplicationGroupId: java.lang.String)
      .replicationGroupId(replicationGroupId: java.lang.String)
      .replicationGroupRegion(replicationGroupRegion: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DisassociateGlobalReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.DisassociateGlobalReplicationGroupRequest
      .wrap(buildAwsValue())
}
object DisassociateGlobalReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DisassociateGlobalReplicationGroupRequest =
      zio.aws.elasticache.model.DisassociateGlobalReplicationGroupRequest(
        globalReplicationGroupId,
        replicationGroupId,
        replicationGroupRegion
      )
    def globalReplicationGroupId: String
    def replicationGroupId: String
    def replicationGroupRegion: String
    def getGlobalReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(globalReplicationGroupId)
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getReplicationGroupRegion: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupRequest
  ) extends zio.aws.elasticache.model.DisassociateGlobalReplicationGroupRequest.ReadOnly {
    override val globalReplicationGroupId: String =
      impl.globalReplicationGroupId(): String
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val replicationGroupRegion: String =
      impl.replicationGroupRegion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DisassociateGlobalReplicationGroupRequest
  ): zio.aws.elasticache.model.DisassociateGlobalReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
