package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FailoverGlobalReplicationGroupResponse(
    globalReplicationGroup: Option[
      zio.aws.elasticache.model.GlobalReplicationGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupResponse = {
    import FailoverGlobalReplicationGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupResponse
      .builder()
      .optionallyWith(
        globalReplicationGroup.map(value => value.buildAwsValue())
      )(_.globalReplicationGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse.ReadOnly =
    zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse
      .wrap(buildAwsValue())
}
object FailoverGlobalReplicationGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse =
      zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse(
        globalReplicationGroup.map(value => value.asEditable)
      )
    def globalReplicationGroup
        : Option[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly]
    def getGlobalReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalReplicationGroup",
      globalReplicationGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupResponse
  ) extends zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse.ReadOnly {
    override val globalReplicationGroup
        : Option[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly] =
      scala
        .Option(impl.globalReplicationGroup())
        .map(value =>
          zio.aws.elasticache.model.GlobalReplicationGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.FailoverGlobalReplicationGroupResponse
  ): zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse.ReadOnly =
    new Wrapper(impl)
}
