package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUserGroupsResponse(
    userGroups: Option[Iterable[zio.aws.elasticache.model.UserGroup]] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse = {
    import DescribeUserGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse
      .builder()
      .optionallyWith(
        userGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userGroups)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeUserGroupsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeUserGroupsResponse.wrap(buildAwsValue())
}
object DescribeUserGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeUserGroupsResponse =
      zio.aws.elasticache.model.DescribeUserGroupsResponse(
        userGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def userGroups: Option[List[zio.aws.elasticache.model.UserGroup.ReadOnly]]
    def marker: Option[String]
    def getUserGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.UserGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("userGroups", userGroups)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse
  ) extends zio.aws.elasticache.model.DescribeUserGroupsResponse.ReadOnly {
    override val userGroups
        : Option[List[zio.aws.elasticache.model.UserGroup.ReadOnly]] = scala
      .Option(impl.userGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.UserGroup.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse
  ): zio.aws.elasticache.model.DescribeUserGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
