package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CacheParameterGroup(
    cacheParameterGroupName: Option[String] = None,
    cacheParameterGroupFamily: Option[String] = None,
    description: Option[String] = None,
    isGlobal: Option[Boolean] = None,
    arn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheParameterGroup = {
    import CacheParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheParameterGroup
      .builder()
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        cacheParameterGroupFamily.map(value => value: java.lang.String)
      )(_.cacheParameterGroupFamily)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(isGlobal.map(value => value: java.lang.Boolean))(
        _.isGlobal
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CacheParameterGroup.ReadOnly =
    zio.aws.elasticache.model.CacheParameterGroup.wrap(buildAwsValue())
}
object CacheParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheParameterGroup =
      zio.aws.elasticache.model.CacheParameterGroup(
        cacheParameterGroupName.map(value => value),
        cacheParameterGroupFamily.map(value => value),
        description.map(value => value),
        isGlobal.map(value => value),
        arn.map(value => value)
      )
    def cacheParameterGroupName: Option[String]
    def cacheParameterGroupFamily: Option[String]
    def description: Option[String]
    def isGlobal: Option[Boolean]
    def arn: Option[String]
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getCacheParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupFamily", cacheParameterGroupFamily)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getIsGlobal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isGlobal", isGlobal)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheParameterGroup
  ) extends zio.aws.elasticache.model.CacheParameterGroup.ReadOnly {
    override val cacheParameterGroupName: Option[String] =
      scala.Option(impl.cacheParameterGroupName()).map(value => value: String)
    override val cacheParameterGroupFamily: Option[String] =
      scala.Option(impl.cacheParameterGroupFamily()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val isGlobal: Option[Boolean] =
      scala.Option(impl.isGlobal()).map(value => value: Boolean)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheParameterGroup
  ): zio.aws.elasticache.model.CacheParameterGroup.ReadOnly = new Wrapper(impl)
}
