package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{
  BooleanOptional,
  AccessString,
  UserId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyUserRequest(
    userId: UserId,
    accessString: Option[AccessString] = None,
    appendAccessString: Option[AccessString] = None,
    passwords: Option[Iterable[String]] = None,
    noPasswordRequired: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyUserRequest = {
    import ModifyUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        accessString.map(value => AccessString.unwrap(value): java.lang.String)
      )(_.accessString)
      .optionallyWith(
        appendAccessString.map(value =>
          AccessString.unwrap(value): java.lang.String
        )
      )(_.appendAccessString)
      .optionallyWith(
        passwords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.passwords)
      .optionallyWith(
        noPasswordRequired.map(value => value: java.lang.Boolean)
      )(_.noPasswordRequired)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ModifyUserRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyUserRequest.wrap(buildAwsValue())
}
object ModifyUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyUserRequest =
      zio.aws.elasticache.model.ModifyUserRequest(
        userId,
        accessString.map(value => value),
        appendAccessString.map(value => value),
        passwords.map(value => value),
        noPasswordRequired.map(value => value)
      )
    def userId: UserId
    def accessString: Option[AccessString]
    def appendAccessString: Option[AccessString]
    def passwords: Option[List[String]]
    def noPasswordRequired: Option[BooleanOptional]
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getAccessString: ZIO[Any, AwsError, AccessString] =
      AwsError.unwrapOptionField("accessString", accessString)
    def getAppendAccessString: ZIO[Any, AwsError, AccessString] =
      AwsError.unwrapOptionField("appendAccessString", appendAccessString)
    def getPasswords: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("passwords", passwords)
    def getNoPasswordRequired: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("noPasswordRequired", noPasswordRequired)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserRequest
  ) extends zio.aws.elasticache.model.ModifyUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.elasticache.model.primitives.UserId(impl.userId())
    override val accessString: Option[AccessString] = scala
      .Option(impl.accessString())
      .map(value => zio.aws.elasticache.model.primitives.AccessString(value))
    override val appendAccessString: Option[AccessString] = scala
      .Option(impl.appendAccessString())
      .map(value => zio.aws.elasticache.model.primitives.AccessString(value))
    override val passwords: Option[List[String]] = scala
      .Option(impl.passwords())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val noPasswordRequired: Option[BooleanOptional] = scala
      .Option(impl.noPasswordRequired())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserRequest
  ): zio.aws.elasticache.model.ModifyUserRequest.ReadOnly = new Wrapper(impl)
}
