package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAllowedNodeTypeModificationsResponse(
    scaleUpModifications: Option[Iterable[String]] = None,
    scaleDownModifications: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse = {
    import ListAllowedNodeTypeModificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse
      .builder()
      .optionallyWith(
        scaleUpModifications.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scaleUpModifications)
      .optionallyWith(
        scaleDownModifications.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scaleDownModifications)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse.ReadOnly =
    zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse
      .wrap(buildAwsValue())
}
object ListAllowedNodeTypeModificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse =
      zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse(
        scaleUpModifications.map(value => value),
        scaleDownModifications.map(value => value)
      )
    def scaleUpModifications: Option[List[String]]
    def scaleDownModifications: Option[List[String]]
    def getScaleUpModifications: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("scaleUpModifications", scaleUpModifications)
    def getScaleDownModifications: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("scaleDownModifications", scaleDownModifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse
  ) extends zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse.ReadOnly {
    override val scaleUpModifications: Option[List[String]] = scala
      .Option(impl.scaleUpModifications())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val scaleDownModifications: Option[List[String]] = scala
      .Option(impl.scaleDownModifications())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsResponse
  ): zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse.ReadOnly =
    new Wrapper(impl)
}
