package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GlobalReplicationGroup(
    globalReplicationGroupId: Option[String] = None,
    globalReplicationGroupDescription: Option[String] = None,
    status: Option[String] = None,
    cacheNodeType: Option[String] = None,
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    members: Option[
      Iterable[zio.aws.elasticache.model.GlobalReplicationGroupMember]
    ] = None,
    clusterEnabled: Option[BooleanOptional] = None,
    globalNodeGroups: Option[
      Iterable[zio.aws.elasticache.model.GlobalNodeGroup]
    ] = None,
    authTokenEnabled: Option[BooleanOptional] = None,
    transitEncryptionEnabled: Option[BooleanOptional] = None,
    atRestEncryptionEnabled: Option[BooleanOptional] = None,
    arn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup = {
    import GlobalReplicationGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup
      .builder()
      .optionallyWith(
        globalReplicationGroupId.map(value => value: java.lang.String)
      )(_.globalReplicationGroupId)
      .optionallyWith(
        globalReplicationGroupDescription.map(value => value: java.lang.String)
      )(_.globalReplicationGroupDescription)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(clusterEnabled.map(value => value: java.lang.Boolean))(
        _.clusterEnabled
      )
      .optionallyWith(
        globalNodeGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalNodeGroups)
      .optionallyWith(authTokenEnabled.map(value => value: java.lang.Boolean))(
        _.authTokenEnabled
      )
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly =
    zio.aws.elasticache.model.GlobalReplicationGroup.wrap(buildAwsValue())
}
object GlobalReplicationGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.GlobalReplicationGroup =
      zio.aws.elasticache.model.GlobalReplicationGroup(
        globalReplicationGroupId.map(value => value),
        globalReplicationGroupDescription.map(value => value),
        status.map(value => value),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterEnabled.map(value => value),
        globalNodeGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        authTokenEnabled.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        arn.map(value => value)
      )
    def globalReplicationGroupId: Option[String]
    def globalReplicationGroupDescription: Option[String]
    def status: Option[String]
    def cacheNodeType: Option[String]
    def engine: Option[String]
    def engineVersion: Option[String]
    def members: Option[
      List[zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly]
    ]
    def clusterEnabled: Option[BooleanOptional]
    def globalNodeGroups
        : Option[List[zio.aws.elasticache.model.GlobalNodeGroup.ReadOnly]]
    def authTokenEnabled: Option[BooleanOptional]
    def transitEncryptionEnabled: Option[BooleanOptional]
    def atRestEncryptionEnabled: Option[BooleanOptional]
    def arn: Option[String]
    def getGlobalReplicationGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalReplicationGroupId", globalReplicationGroupId)
    def getGlobalReplicationGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "globalReplicationGroupDescription",
        globalReplicationGroupDescription
      )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getMembers: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly
    ]] = AwsError.unwrapOptionField("members", members)
    def getClusterEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("clusterEnabled", clusterEnabled)
    def getGlobalNodeGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.GlobalNodeGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("globalNodeGroups", globalNodeGroups)
    def getAuthTokenEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("authTokenEnabled", authTokenEnabled)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "atRestEncryptionEnabled",
        atRestEncryptionEnabled
      )
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup
  ) extends zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly {
    override val globalReplicationGroupId: Option[String] =
      scala.Option(impl.globalReplicationGroupId()).map(value => value: String)
    override val globalReplicationGroupDescription: Option[String] = scala
      .Option(impl.globalReplicationGroupDescription())
      .map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val members: Option[
      List[zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly]
    ] = scala
      .Option(impl.members())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.GlobalReplicationGroupMember.wrap(item)
        }.toList
      )
    override val clusterEnabled: Option[BooleanOptional] =
      scala.Option(impl.clusterEnabled()).map(value => value: BooleanOptional)
    override val globalNodeGroups
        : Option[List[zio.aws.elasticache.model.GlobalNodeGroup.ReadOnly]] =
      scala
        .Option(impl.globalNodeGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.GlobalNodeGroup.wrap(item)
          }.toList
        )
    override val authTokenEnabled: Option[BooleanOptional] =
      scala.Option(impl.authTokenEnabled()).map(value => value: BooleanOptional)
    override val transitEncryptionEnabled: Option[BooleanOptional] = scala
      .Option(impl.transitEncryptionEnabled())
      .map(value => value: BooleanOptional)
    override val atRestEncryptionEnabled: Option[BooleanOptional] = scala
      .Option(impl.atRestEncryptionEnabled())
      .map(value => value: BooleanOptional)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup
  ): zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly = new Wrapper(
    impl
  )
}
