package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCacheSecurityGroupsRequest(
    cacheSecurityGroupName: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest = {
    import DescribeCacheSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest
      .builder()
      .optionallyWith(
        cacheSecurityGroupName.map(value => value: java.lang.String)
      )(_.cacheSecurityGroupName)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheSecurityGroupsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheSecurityGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeCacheSecurityGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeCacheSecurityGroupsRequest =
      zio.aws.elasticache.model.DescribeCacheSecurityGroupsRequest(
        cacheSecurityGroupName.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def cacheSecurityGroupName: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getCacheSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheSecurityGroupName", cacheSecurityGroupName)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest
  ) extends zio.aws.elasticache.model.DescribeCacheSecurityGroupsRequest.ReadOnly {
    override val cacheSecurityGroupName: Option[String] =
      scala.Option(impl.cacheSecurityGroupName()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsRequest
  ): zio.aws.elasticache.model.DescribeCacheSecurityGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
