package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SubnetOutpost(subnetOutpostArn: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.SubnetOutpost = {
    import SubnetOutpost.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.SubnetOutpost
      .builder()
      .optionallyWith(subnetOutpostArn.map(value => value: java.lang.String))(
        _.subnetOutpostArn
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.SubnetOutpost.ReadOnly =
    zio.aws.elasticache.model.SubnetOutpost.wrap(buildAwsValue())
}
object SubnetOutpost {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.SubnetOutpost
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.SubnetOutpost =
      zio.aws.elasticache.model
        .SubnetOutpost(subnetOutpostArn.map(value => value))
    def subnetOutpostArn: Option[String]
    def getSubnetOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetOutpostArn", subnetOutpostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.SubnetOutpost
  ) extends zio.aws.elasticache.model.SubnetOutpost.ReadOnly {
    override val subnetOutpostArn: Option[String] =
      scala.Option(impl.subnetOutpostArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.SubnetOutpost
  ): zio.aws.elasticache.model.SubnetOutpost.ReadOnly = new Wrapper(impl)
}
