package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RebootCacheClusterResponse(
    cacheCluster: Option[zio.aws.elasticache.model.CacheCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse = {
    import RebootCacheClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse
      .builder()
      .optionallyWith(cacheCluster.map(value => value.buildAwsValue()))(
        _.cacheCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.RebootCacheClusterResponse.ReadOnly =
    zio.aws.elasticache.model.RebootCacheClusterResponse.wrap(buildAwsValue())
}
object RebootCacheClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.RebootCacheClusterResponse =
      zio.aws.elasticache.model
        .RebootCacheClusterResponse(cacheCluster.map(value => value.asEditable))
    def cacheCluster: Option[zio.aws.elasticache.model.CacheCluster.ReadOnly]
    def getCacheCluster
        : ZIO[Any, AwsError, zio.aws.elasticache.model.CacheCluster.ReadOnly] =
      AwsError.unwrapOptionField("cacheCluster", cacheCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse
  ) extends zio.aws.elasticache.model.RebootCacheClusterResponse.ReadOnly {
    override val cacheCluster
        : Option[zio.aws.elasticache.model.CacheCluster.ReadOnly] = scala
      .Option(impl.cacheCluster())
      .map(value => zio.aws.elasticache.model.CacheCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.RebootCacheClusterResponse
  ): zio.aws.elasticache.model.RebootCacheClusterResponse.ReadOnly =
    new Wrapper(impl)
}
