package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CacheNodeTypeSpecificParameter(
    parameterName: Option[String] = None,
    description: Option[String] = None,
    source: Option[String] = None,
    dataType: Option[String] = None,
    allowedValues: Option[String] = None,
    isModifiable: Option[Boolean] = None,
    minimumEngineVersion: Option[String] = None,
    cacheNodeTypeSpecificValues: Option[
      Iterable[zio.aws.elasticache.model.CacheNodeTypeSpecificValue]
    ] = None,
    changeType: Option[zio.aws.elasticache.model.ChangeType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter = {
    import CacheNodeTypeSpecificParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(
        cacheNodeTypeSpecificValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheNodeTypeSpecificValues)
      .optionallyWith(changeType.map(value => value.unwrap))(_.changeType)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly =
    zio.aws.elasticache.model.CacheNodeTypeSpecificParameter
      .wrap(buildAwsValue())
}
object CacheNodeTypeSpecificParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheNodeTypeSpecificParameter =
      zio.aws.elasticache.model.CacheNodeTypeSpecificParameter(
        parameterName.map(value => value),
        description.map(value => value),
        source.map(value => value),
        dataType.map(value => value),
        allowedValues.map(value => value),
        isModifiable.map(value => value),
        minimumEngineVersion.map(value => value),
        cacheNodeTypeSpecificValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        changeType.map(value => value)
      )
    def parameterName: Option[String]
    def description: Option[String]
    def source: Option[String]
    def dataType: Option[String]
    def allowedValues: Option[String]
    def isModifiable: Option[Boolean]
    def minimumEngineVersion: Option[String]
    def cacheNodeTypeSpecificValues: Option[
      List[zio.aws.elasticache.model.CacheNodeTypeSpecificValue.ReadOnly]
    ]
    def changeType: Option[zio.aws.elasticache.model.ChangeType]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getCacheNodeTypeSpecificValues: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheNodeTypeSpecificValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cacheNodeTypeSpecificValues",
      cacheNodeTypeSpecificValues
    )
    def getChangeType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ChangeType] =
      AwsError.unwrapOptionField("changeType", changeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter
  ) extends zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly {
    override val parameterName: Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val dataType: Option[String] =
      scala.Option(impl.dataType()).map(value => value: String)
    override val allowedValues: Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override val isModifiable: Option[Boolean] =
      scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override val minimumEngineVersion: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override val cacheNodeTypeSpecificValues: Option[
      List[zio.aws.elasticache.model.CacheNodeTypeSpecificValue.ReadOnly]
    ] = scala
      .Option(impl.cacheNodeTypeSpecificValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheNodeTypeSpecificValue.wrap(item)
        }.toList
      )
    override val changeType: Option[zio.aws.elasticache.model.ChangeType] =
      scala
        .Option(impl.changeType())
        .map(value => zio.aws.elasticache.model.ChangeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter
  ): zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly =
    new Wrapper(impl)
}
