package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.{
  IntegerOptional,
  AllowedNodeGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodeGroupConfiguration(
    nodeGroupId: Option[AllowedNodeGroupId] = None,
    slots: Option[String] = None,
    replicaCount: Option[IntegerOptional] = None,
    primaryAvailabilityZone: Option[String] = None,
    replicaAvailabilityZones: Option[Iterable[String]] = None,
    primaryOutpostArn: Option[String] = None,
    replicaOutpostArns: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration = {
    import NodeGroupConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration
      .builder()
      .optionallyWith(
        nodeGroupId.map(value =>
          AllowedNodeGroupId.unwrap(value): java.lang.String
        )
      )(_.nodeGroupId)
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(replicaCount.map(value => value: Integer))(_.replicaCount)
      .optionallyWith(
        primaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.primaryAvailabilityZone)
      .optionallyWith(
        replicaAvailabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicaAvailabilityZones)
      .optionallyWith(primaryOutpostArn.map(value => value: java.lang.String))(
        _.primaryOutpostArn
      )
      .optionallyWith(
        replicaOutpostArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicaOutpostArns)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly =
    zio.aws.elasticache.model.NodeGroupConfiguration.wrap(buildAwsValue())
}
object NodeGroupConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NodeGroupConfiguration =
      zio.aws.elasticache.model.NodeGroupConfiguration(
        nodeGroupId.map(value => value),
        slots.map(value => value),
        replicaCount.map(value => value),
        primaryAvailabilityZone.map(value => value),
        replicaAvailabilityZones.map(value => value),
        primaryOutpostArn.map(value => value),
        replicaOutpostArns.map(value => value)
      )
    def nodeGroupId: Option[AllowedNodeGroupId]
    def slots: Option[String]
    def replicaCount: Option[IntegerOptional]
    def primaryAvailabilityZone: Option[String]
    def replicaAvailabilityZones: Option[List[String]]
    def primaryOutpostArn: Option[String]
    def replicaOutpostArns: Option[List[String]]
    def getNodeGroupId: ZIO[Any, AwsError, AllowedNodeGroupId] =
      AwsError.unwrapOptionField("nodeGroupId", nodeGroupId)
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getReplicaCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("replicaCount", replicaCount)
    def getPrimaryAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("primaryAvailabilityZone", primaryAvailabilityZone)
    def getReplicaAvailabilityZones: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("replicaAvailabilityZones", replicaAvailabilityZones)
    def getPrimaryOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryOutpostArn", primaryOutpostArn)
    def getReplicaOutpostArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicaOutpostArns", replicaOutpostArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration
  ) extends zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly {
    override val nodeGroupId: Option[AllowedNodeGroupId] = scala
      .Option(impl.nodeGroupId())
      .map(value =>
        zio.aws.elasticache.model.primitives.AllowedNodeGroupId(value)
      )
    override val slots: Option[String] =
      scala.Option(impl.slots()).map(value => value: String)
    override val replicaCount: Option[IntegerOptional] =
      scala.Option(impl.replicaCount()).map(value => value: IntegerOptional)
    override val primaryAvailabilityZone: Option[String] =
      scala.Option(impl.primaryAvailabilityZone()).map(value => value: String)
    override val replicaAvailabilityZones: Option[List[String]] = scala
      .Option(impl.replicaAvailabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val primaryOutpostArn: Option[String] =
      scala.Option(impl.primaryOutpostArn()).map(value => value: String)
    override val replicaOutpostArns: Option[List[String]] = scala
      .Option(impl.replicaOutpostArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration
  ): zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
