package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAllowedNodeTypeModificationsRequest(
    cacheClusterId: Option[String] = None,
    replicationGroupId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest = {
    import ListAllowedNodeTypeModificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ListAllowedNodeTypeModificationsRequest.ReadOnly =
    zio.aws.elasticache.model.ListAllowedNodeTypeModificationsRequest
      .wrap(buildAwsValue())
}
object ListAllowedNodeTypeModificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.ListAllowedNodeTypeModificationsRequest =
      zio.aws.elasticache.model.ListAllowedNodeTypeModificationsRequest(
        cacheClusterId.map(value => value),
        replicationGroupId.map(value => value)
      )
    def cacheClusterId: Option[String]
    def replicationGroupId: Option[String]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest
  ) extends zio.aws.elasticache.model.ListAllowedNodeTypeModificationsRequest.ReadOnly {
    override val cacheClusterId: Option[String] =
      scala.Option(impl.cacheClusterId()).map(value => value: String)
    override val replicationGroupId: Option[String] =
      scala.Option(impl.replicationGroupId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ListAllowedNodeTypeModificationsRequest
  ): zio.aws.elasticache.model.ListAllowedNodeTypeModificationsRequest.ReadOnly =
    new Wrapper(impl)
}
