package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedCacheNodesOfferingsRequest(
    reservedCacheNodesOfferingId: Option[String] = None,
    cacheNodeType: Option[String] = None,
    duration: Option[String] = None,
    productDescription: Option[String] = None,
    offeringType: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest = {
    import DescribeReservedCacheNodesOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
      .builder()
      .optionallyWith(
        reservedCacheNodesOfferingId.map(value => value: java.lang.String)
      )(_.reservedCacheNodesOfferingId)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(duration.map(value => value: java.lang.String))(
        _.duration
      )
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedCacheNodesOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest =
      zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest(
        reservedCacheNodesOfferingId.map(value => value),
        cacheNodeType.map(value => value),
        duration.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def reservedCacheNodesOfferingId: Option[String]
    def cacheNodeType: Option[String]
    def duration: Option[String]
    def productDescription: Option[String]
    def offeringType: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getReservedCacheNodesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedCacheNodesOfferingId",
        reservedCacheNodesOfferingId
      )
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getDuration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("duration", duration)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
  ) extends zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest.ReadOnly {
    override val reservedCacheNodesOfferingId: Option[String] = scala
      .Option(impl.reservedCacheNodesOfferingId())
      .map(value => value: String)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val duration: Option[String] =
      scala.Option(impl.duration()).map(value => value: String)
    override val productDescription: Option[String] =
      scala.Option(impl.productDescription()).map(value => value: String)
    override val offeringType: Option[String] =
      scala.Option(impl.offeringType()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
  ): zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
