package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.{
  UserGroupId,
  IntegerOptional,
  BooleanOptional
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateReplicationGroupRequest(
    replicationGroupId: String,
    replicationGroupDescription: String,
    globalReplicationGroupId: Option[String] = None,
    primaryClusterId: Option[String] = None,
    automaticFailoverEnabled: Option[BooleanOptional] = None,
    multiAZEnabled: Option[BooleanOptional] = None,
    numCacheClusters: Option[IntegerOptional] = None,
    preferredCacheClusterAZs: Option[Iterable[String]] = None,
    numNodeGroups: Option[IntegerOptional] = None,
    replicasPerNodeGroup: Option[IntegerOptional] = None,
    nodeGroupConfiguration: Option[
      Iterable[zio.aws.elasticache.model.NodeGroupConfiguration]
    ] = None,
    cacheNodeType: Option[String] = None,
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    cacheParameterGroupName: Option[String] = None,
    cacheSubnetGroupName: Option[String] = None,
    cacheSecurityGroupNames: Option[Iterable[String]] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    tags: Option[Iterable[zio.aws.elasticache.model.Tag]] = None,
    snapshotArns: Option[Iterable[String]] = None,
    snapshotName: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    port: Option[IntegerOptional] = None,
    notificationTopicArn: Option[String] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    snapshotWindow: Option[String] = None,
    authToken: Option[String] = None,
    transitEncryptionEnabled: Option[BooleanOptional] = None,
    atRestEncryptionEnabled: Option[BooleanOptional] = None,
    kmsKeyId: Option[String] = None,
    userGroupIds: Option[Iterable[UserGroupId]] = None,
    logDeliveryConfigurations: Option[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfigurationRequest]
    ] = None,
    dataTieringEnabled: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest = {
    import CreateReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .replicationGroupDescription(
        replicationGroupDescription: java.lang.String
      )
      .optionallyWith(
        globalReplicationGroupId.map(value => value: java.lang.String)
      )(_.globalReplicationGroupId)
      .optionallyWith(primaryClusterId.map(value => value: java.lang.String))(
        _.primaryClusterId
      )
      .optionallyWith(
        automaticFailoverEnabled.map(value => value: java.lang.Boolean)
      )(_.automaticFailoverEnabled)
      .optionallyWith(multiAZEnabled.map(value => value: java.lang.Boolean))(
        _.multiAZEnabled
      )
      .optionallyWith(numCacheClusters.map(value => value: Integer))(
        _.numCacheClusters
      )
      .optionallyWith(
        preferredCacheClusterAZs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.preferredCacheClusterAZs)
      .optionallyWith(numNodeGroups.map(value => value: Integer))(
        _.numNodeGroups
      )
      .optionallyWith(replicasPerNodeGroup.map(value => value: Integer))(
        _.replicasPerNodeGroup
      )
      .optionallyWith(
        nodeGroupConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeGroupConfiguration)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(
        cacheSecurityGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheSecurityGroupNames)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        snapshotArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotArns)
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(authToken.map(value => value: java.lang.String))(
        _.authToken
      )
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        userGroupIds.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIds)
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .optionallyWith(
        dataTieringEnabled.map(value => value: java.lang.Boolean)
      )(_.dataTieringEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.CreateReplicationGroupRequest
      .wrap(buildAwsValue())
}
object CreateReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateReplicationGroupRequest =
      zio.aws.elasticache.model.CreateReplicationGroupRequest(
        replicationGroupId,
        replicationGroupDescription,
        globalReplicationGroupId.map(value => value),
        primaryClusterId.map(value => value),
        automaticFailoverEnabled.map(value => value),
        multiAZEnabled.map(value => value),
        numCacheClusters.map(value => value),
        preferredCacheClusterAZs.map(value => value),
        numNodeGroups.map(value => value),
        replicasPerNodeGroup.map(value => value),
        nodeGroupConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        cacheParameterGroupName.map(value => value),
        cacheSubnetGroupName.map(value => value),
        cacheSecurityGroupNames.map(value => value),
        securityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshotArns.map(value => value),
        snapshotName.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        port.map(value => value),
        notificationTopicArn.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        authToken.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        kmsKeyId.map(value => value),
        userGroupIds.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataTieringEnabled.map(value => value)
      )
    def replicationGroupId: String
    def replicationGroupDescription: String
    def globalReplicationGroupId: Option[String]
    def primaryClusterId: Option[String]
    def automaticFailoverEnabled: Option[BooleanOptional]
    def multiAZEnabled: Option[BooleanOptional]
    def numCacheClusters: Option[IntegerOptional]
    def preferredCacheClusterAZs: Option[List[String]]
    def numNodeGroups: Option[IntegerOptional]
    def replicasPerNodeGroup: Option[IntegerOptional]
    def nodeGroupConfiguration: Option[
      List[zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly]
    ]
    def cacheNodeType: Option[String]
    def engine: Option[String]
    def engineVersion: Option[String]
    def cacheParameterGroupName: Option[String]
    def cacheSubnetGroupName: Option[String]
    def cacheSecurityGroupNames: Option[List[String]]
    def securityGroupIds: Option[List[String]]
    def tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def snapshotArns: Option[List[String]]
    def snapshotName: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def port: Option[IntegerOptional]
    def notificationTopicArn: Option[String]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def snapshotWindow: Option[String]
    def authToken: Option[String]
    def transitEncryptionEnabled: Option[BooleanOptional]
    def atRestEncryptionEnabled: Option[BooleanOptional]
    def kmsKeyId: Option[String]
    def userGroupIds: Option[List[UserGroupId]]
    def logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ]
    def dataTieringEnabled: Option[BooleanOptional]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getReplicationGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupDescription)
    def getGlobalReplicationGroupId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalReplicationGroupId", globalReplicationGroupId)
    def getPrimaryClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryClusterId", primaryClusterId)
    def getAutomaticFailoverEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "automaticFailoverEnabled",
        automaticFailoverEnabled
      )
    def getMultiAZEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZEnabled", multiAZEnabled)
    def getNumCacheClusters: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheClusters", numCacheClusters)
    def getPreferredCacheClusterAZs: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("preferredCacheClusterAZs", preferredCacheClusterAZs)
    def getNumNodeGroups: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numNodeGroups", numNodeGroups)
    def getReplicasPerNodeGroup: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("replicasPerNodeGroup", replicasPerNodeGroup)
    def getNodeGroupConfiguration: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "nodeGroupConfiguration",
      nodeGroupConfiguration
    )
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getCacheSecurityGroupNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("cacheSecurityGroupNames", cacheSecurityGroupNames)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSnapshotArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("snapshotArns", snapshotArns)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAuthToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authToken", authToken)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "atRestEncryptionEnabled",
        atRestEncryptionEnabled
      )
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getUserGroupIds: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIds", userGroupIds)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
    def getDataTieringEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("dataTieringEnabled", dataTieringEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest
  ) extends zio.aws.elasticache.model.CreateReplicationGroupRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val replicationGroupDescription: String =
      impl.replicationGroupDescription(): String
    override val globalReplicationGroupId: Option[String] =
      scala.Option(impl.globalReplicationGroupId()).map(value => value: String)
    override val primaryClusterId: Option[String] =
      scala.Option(impl.primaryClusterId()).map(value => value: String)
    override val automaticFailoverEnabled: Option[BooleanOptional] = scala
      .Option(impl.automaticFailoverEnabled())
      .map(value => value: BooleanOptional)
    override val multiAZEnabled: Option[BooleanOptional] =
      scala.Option(impl.multiAZEnabled()).map(value => value: BooleanOptional)
    override val numCacheClusters: Option[IntegerOptional] =
      scala.Option(impl.numCacheClusters()).map(value => value: IntegerOptional)
    override val preferredCacheClusterAZs: Option[List[String]] = scala
      .Option(impl.preferredCacheClusterAZs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val numNodeGroups: Option[IntegerOptional] =
      scala.Option(impl.numNodeGroups()).map(value => value: IntegerOptional)
    override val replicasPerNodeGroup: Option[IntegerOptional] = scala
      .Option(impl.replicasPerNodeGroup())
      .map(value => value: IntegerOptional)
    override val nodeGroupConfiguration: Option[
      List[zio.aws.elasticache.model.NodeGroupConfiguration.ReadOnly]
    ] = scala
      .Option(impl.nodeGroupConfiguration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.NodeGroupConfiguration.wrap(item)
        }.toList
      )
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val cacheParameterGroupName: Option[String] =
      scala.Option(impl.cacheParameterGroupName()).map(value => value: String)
    override val cacheSubnetGroupName: Option[String] =
      scala.Option(impl.cacheSubnetGroupName()).map(value => value: String)
    override val cacheSecurityGroupNames: Option[List[String]] = scala
      .Option(impl.cacheSecurityGroupNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
    override val snapshotArns: Option[List[String]] = scala
      .Option(impl.snapshotArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotName: Option[String] =
      scala.Option(impl.snapshotName()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val notificationTopicArn: Option[String] =
      scala.Option(impl.notificationTopicArn()).map(value => value: String)
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => value: BooleanOptional)
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => value: IntegerOptional)
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val authToken: Option[String] =
      scala.Option(impl.authToken()).map(value => value: String)
    override val transitEncryptionEnabled: Option[BooleanOptional] = scala
      .Option(impl.transitEncryptionEnabled())
      .map(value => value: BooleanOptional)
    override val atRestEncryptionEnabled: Option[BooleanOptional] = scala
      .Option(impl.atRestEncryptionEnabled())
      .map(value => value: BooleanOptional)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val userGroupIds: Option[List[UserGroupId]] = scala
      .Option(impl.userGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserGroupId(item)
        }.toList
      )
    override val logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ] = scala
      .Option(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfigurationRequest.wrap(item)
        }.toList
      )
    override val dataTieringEnabled: Option[BooleanOptional] = scala
      .Option(impl.dataTieringEnabled())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateReplicationGroupRequest
  ): zio.aws.elasticache.model.CreateReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
