package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopySnapshotRequest(
    sourceSnapshotName: String,
    targetSnapshotName: String,
    targetBucket: Option[String] = None,
    kmsKeyId: Option[String] = None,
    tags: Option[Iterable[zio.aws.elasticache.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest = {
    import CopySnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest
      .builder()
      .sourceSnapshotName(sourceSnapshotName: java.lang.String)
      .targetSnapshotName(targetSnapshotName: java.lang.String)
      .optionallyWith(targetBucket.map(value => value: java.lang.String))(
        _.targetBucket
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CopySnapshotRequest.ReadOnly =
    zio.aws.elasticache.model.CopySnapshotRequest.wrap(buildAwsValue())
}
object CopySnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CopySnapshotRequest =
      zio.aws.elasticache.model.CopySnapshotRequest(
        sourceSnapshotName,
        targetSnapshotName,
        targetBucket.map(value => value),
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceSnapshotName: String
    def targetSnapshotName: String
    def targetBucket: Option[String]
    def kmsKeyId: Option[String]
    def tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def getSourceSnapshotName: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceSnapshotName)
    def getTargetSnapshotName: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetSnapshotName)
    def getTargetBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetBucket", targetBucket)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest
  ) extends zio.aws.elasticache.model.CopySnapshotRequest.ReadOnly {
    override val sourceSnapshotName: String = impl.sourceSnapshotName(): String
    override val targetSnapshotName: String = impl.targetSnapshotName(): String
    override val targetBucket: Option[String] =
      scala.Option(impl.targetBucket()).map(value => value: String)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CopySnapshotRequest
  ): zio.aws.elasticache.model.CopySnapshotRequest.ReadOnly = new Wrapper(impl)
}
