package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PendingModifiedValues(
    numCacheNodes: Option[IntegerOptional] = None,
    cacheNodeIdsToRemove: Option[Iterable[String]] = None,
    engineVersion: Option[String] = None,
    cacheNodeType: Option[String] = None,
    authTokenStatus: Option[zio.aws.elasticache.model.AuthTokenUpdateStatus] =
      None,
    logDeliveryConfigurations: Option[
      Iterable[zio.aws.elasticache.model.PendingLogDeliveryConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.PendingModifiedValues = {
    import PendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.PendingModifiedValues
      .builder()
      .optionallyWith(numCacheNodes.map(value => value: Integer))(
        _.numCacheNodes
      )
      .optionallyWith(
        cacheNodeIdsToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheNodeIdsToRemove)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(authTokenStatus.map(value => value.unwrap))(
        _.authTokenStatus
      )
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.PendingModifiedValues.ReadOnly =
    zio.aws.elasticache.model.PendingModifiedValues.wrap(buildAwsValue())
}
object PendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.PendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.PendingModifiedValues =
      zio.aws.elasticache.model.PendingModifiedValues(
        numCacheNodes.map(value => value),
        cacheNodeIdsToRemove.map(value => value),
        engineVersion.map(value => value),
        cacheNodeType.map(value => value),
        authTokenStatus.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def numCacheNodes: Option[IntegerOptional]
    def cacheNodeIdsToRemove: Option[List[String]]
    def engineVersion: Option[String]
    def cacheNodeType: Option[String]
    def authTokenStatus: Option[zio.aws.elasticache.model.AuthTokenUpdateStatus]
    def logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly]
    ]
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getCacheNodeIdsToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheNodeIdsToRemove", cacheNodeIdsToRemove)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getAuthTokenStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.AuthTokenUpdateStatus] =
      AwsError.unwrapOptionField("authTokenStatus", authTokenStatus)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.PendingModifiedValues
  ) extends zio.aws.elasticache.model.PendingModifiedValues.ReadOnly {
    override val numCacheNodes: Option[IntegerOptional] =
      scala.Option(impl.numCacheNodes()).map(value => value: IntegerOptional)
    override val cacheNodeIdsToRemove: Option[List[String]] = scala
      .Option(impl.cacheNodeIdsToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val authTokenStatus
        : Option[zio.aws.elasticache.model.AuthTokenUpdateStatus] = scala
      .Option(impl.authTokenStatus())
      .map(value => zio.aws.elasticache.model.AuthTokenUpdateStatus.wrap(value))
    override val logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly]
    ] = scala
      .Option(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.PendingLogDeliveryConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.PendingModifiedValues
  ): zio.aws.elasticache.model.PendingModifiedValues.ReadOnly = new Wrapper(
    impl
  )
}
