package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IncreaseReplicaCountRequest(
    replicationGroupId: String,
    newReplicaCount: Option[IntegerOptional] = None,
    replicaConfiguration: Option[
      Iterable[zio.aws.elasticache.model.ConfigureShard]
    ] = None,
    applyImmediately: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest = {
    import IncreaseReplicaCountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .optionallyWith(newReplicaCount.map(value => value: Integer))(
        _.newReplicaCount
      )
      .optionallyWith(
        replicaConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaConfiguration)
      .applyImmediately(applyImmediately: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.IncreaseReplicaCountRequest.ReadOnly =
    zio.aws.elasticache.model.IncreaseReplicaCountRequest.wrap(buildAwsValue())
}
object IncreaseReplicaCountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.IncreaseReplicaCountRequest =
      zio.aws.elasticache.model.IncreaseReplicaCountRequest(
        replicationGroupId,
        newReplicaCount.map(value => value),
        replicaConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applyImmediately
      )
    def replicationGroupId: String
    def newReplicaCount: Option[IntegerOptional]
    def replicaConfiguration
        : Option[List[zio.aws.elasticache.model.ConfigureShard.ReadOnly]]
    def applyImmediately: Boolean
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getNewReplicaCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("newReplicaCount", newReplicaCount)
    def getReplicaConfiguration: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ConfigureShard.ReadOnly
    ]] =
      AwsError.unwrapOptionField("replicaConfiguration", replicaConfiguration)
    def getApplyImmediately: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(applyImmediately)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest
  ) extends zio.aws.elasticache.model.IncreaseReplicaCountRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val newReplicaCount: Option[IntegerOptional] =
      scala.Option(impl.newReplicaCount()).map(value => value: IntegerOptional)
    override val replicaConfiguration
        : Option[List[zio.aws.elasticache.model.ConfigureShard.ReadOnly]] =
      scala
        .Option(impl.replicaConfiguration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.ConfigureShard.wrap(item)
          }.toList
        )
    override val applyImmediately: Boolean = impl.applyImmediately(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountRequest
  ): zio.aws.elasticache.model.IncreaseReplicaCountRequest.ReadOnly =
    new Wrapper(impl)
}
