package zio.aws.elasticache
import zio.aws.elasticache.model.BatchStopUpdateActionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.elasticache.model.{
  DeleteUserRequest,
  DescribeReservedCacheNodesRequest,
  DescribeUsersRequest,
  ModifyCacheParameterGroupRequest,
  AuthorizeCacheSecurityGroupIngressRequest,
  DescribeSnapshotsRequest,
  DescribeEngineDefaultParametersRequest,
  DeleteSnapshotRequest,
  AddTagsToResourceRequest,
  DeleteGlobalReplicationGroupRequest,
  DescribeGlobalReplicationGroupsRequest,
  DescribeCacheParameterGroupsRequest,
  DisassociateGlobalReplicationGroupRequest,
  DecreaseReplicaCountRequest,
  DescribeCacheEngineVersionsRequest,
  DeleteCacheClusterRequest,
  ListAllowedNodeTypeModificationsRequest,
  DescribeEventsRequest,
  RebalanceSlotsInGlobalReplicationGroupRequest,
  PurchaseReservedCacheNodesOfferingRequest,
  ListTagsForResourceRequest,
  ModifyGlobalReplicationGroupRequest,
  CreateUserGroupRequest,
  CopySnapshotRequest,
  DescribeCacheClustersRequest,
  CreateCacheSubnetGroupRequest,
  DescribeCacheSubnetGroupsRequest,
  ModifyUserRequest,
  IncreaseReplicaCountRequest,
  CreateGlobalReplicationGroupRequest,
  CreateCacheClusterRequest,
  RebootCacheClusterRequest,
  ModifyUserGroupRequest,
  DescribeReservedCacheNodesOfferingsRequest,
  DecreaseNodeGroupsInGlobalReplicationGroupRequest,
  RevokeCacheSecurityGroupIngressRequest,
  CreateUserRequest,
  DescribeServiceUpdatesRequest,
  DescribeCacheSecurityGroupsRequest,
  BatchApplyUpdateActionRequest,
  TestFailoverRequest,
  ModifyCacheSubnetGroupRequest,
  RemoveTagsFromResourceRequest,
  CreateCacheSecurityGroupRequest,
  ModifyReplicationGroupShardConfigurationRequest,
  CreateReplicationGroupRequest,
  DescribeUpdateActionsRequest,
  ModifyReplicationGroupRequest,
  DescribeCacheParametersRequest,
  CompleteMigrationRequest,
  BatchStopUpdateActionRequest,
  ModifyCacheClusterRequest,
  CreateSnapshotRequest,
  DescribeUserGroupsRequest,
  CreateCacheParameterGroupRequest,
  DeleteReplicationGroupRequest,
  IncreaseNodeGroupsInGlobalReplicationGroupRequest,
  DeleteCacheSecurityGroupRequest,
  DeleteCacheSubnetGroupRequest,
  FailoverGlobalReplicationGroupRequest,
  ResetCacheParameterGroupRequest,
  DeleteCacheParameterGroupRequest,
  StartMigrationRequest,
  DescribeReplicationGroupsRequest,
  DeleteUserGroupRequest
}
import zio.stream.ZStream
object ElastiCacheMock extends Mock[ElastiCache] {
  object DescribeEngineDefaultParameters
      extends Effect[
        DescribeEngineDefaultParametersRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse.ReadOnly
      ]
  object DescribeCacheSecurityGroups
      extends Stream[
        DescribeCacheSecurityGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly
      ]
  object DescribeCacheSecurityGroupsPaginated
      extends Effect[
        DescribeCacheSecurityGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse.ReadOnly
      ]
  object ResetCacheParameterGroup
      extends Effect[
        ResetCacheParameterGroupRequest,
        AwsError,
        zio.aws.elasticache.model.ResetCacheParameterGroupResponse.ReadOnly
      ]
  object DescribeCacheParameters
      extends Stream[
        DescribeCacheParametersRequest,
        AwsError,
        zio.aws.elasticache.model.Parameter.ReadOnly
      ]
  object DescribeCacheParametersPaginated
      extends Effect[
        DescribeCacheParametersRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeCacheParametersResponse.ReadOnly
      ]
  object AddTagsToResource
      extends Effect[
        AddTagsToResourceRequest,
        AwsError,
        zio.aws.elasticache.model.AddTagsToResourceResponse.ReadOnly
      ]
  object CreateCacheParameterGroup
      extends Effect[
        CreateCacheParameterGroupRequest,
        AwsError,
        zio.aws.elasticache.model.CreateCacheParameterGroupResponse.ReadOnly
      ]
  object CreateGlobalReplicationGroup
      extends Effect[
        CreateGlobalReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse.ReadOnly
      ]
  object DeleteCacheParameterGroup
      extends Effect[DeleteCacheParameterGroupRequest, AwsError, Unit]
  object CompleteMigration
      extends Effect[
        CompleteMigrationRequest,
        AwsError,
        zio.aws.elasticache.model.CompleteMigrationResponse.ReadOnly
      ]
  object DeleteGlobalReplicationGroup
      extends Effect[
        DeleteGlobalReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse.ReadOnly
      ]
  object DescribeCacheParameterGroups
      extends Stream[
        DescribeCacheParameterGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.CacheParameterGroup.ReadOnly
      ]
  object DescribeCacheParameterGroupsPaginated
      extends Effect[
        DescribeCacheParameterGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse.ReadOnly
      ]
  object IncreaseReplicaCount
      extends Effect[
        IncreaseReplicaCountRequest,
        AwsError,
        zio.aws.elasticache.model.IncreaseReplicaCountResponse.ReadOnly
      ]
  object ModifyUser
      extends Effect[
        ModifyUserRequest,
        AwsError,
        zio.aws.elasticache.model.ModifyUserResponse.ReadOnly
      ]
  object DescribeCacheEngineVersions
      extends Stream[
        DescribeCacheEngineVersionsRequest,
        AwsError,
        zio.aws.elasticache.model.CacheEngineVersion.ReadOnly
      ]
  object DescribeCacheEngineVersionsPaginated
      extends Effect[
        DescribeCacheEngineVersionsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse.ReadOnly
      ]
  object ListAllowedNodeTypeModifications
      extends Effect[
        ListAllowedNodeTypeModificationsRequest,
        AwsError,
        zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse.ReadOnly
      ]
  object DeleteReplicationGroup
      extends Effect[
        DeleteReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.DeleteReplicationGroupResponse.ReadOnly
      ]
  object CreateReplicationGroup
      extends Effect[
        CreateReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.CreateReplicationGroupResponse.ReadOnly
      ]
  object DescribeCacheSubnetGroups
      extends Stream[
        DescribeCacheSubnetGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly
      ]
  object DescribeCacheSubnetGroupsPaginated
      extends Effect[
        DescribeCacheSubnetGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly
      ]
  object ModifyCacheSubnetGroup
      extends Effect[
        ModifyCacheSubnetGroupRequest,
        AwsError,
        zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse.ReadOnly
      ]
  object ModifyReplicationGroup
      extends Effect[
        ModifyReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.ModifyReplicationGroupResponse.ReadOnly
      ]
  object CopySnapshot
      extends Effect[
        CopySnapshotRequest,
        AwsError,
        zio.aws.elasticache.model.CopySnapshotResponse.ReadOnly
      ]
  object PurchaseReservedCacheNodesOffering
      extends Effect[
        PurchaseReservedCacheNodesOfferingRequest,
        AwsError,
        zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse.ReadOnly
      ]
  object IncreaseNodeGroupsInGlobalReplicationGroup
      extends Effect[
        IncreaseNodeGroupsInGlobalReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
      ]
  object RemoveTagsFromResource
      extends Effect[
        RemoveTagsFromResourceRequest,
        AwsError,
        zio.aws.elasticache.model.RemoveTagsFromResourceResponse.ReadOnly
      ]
  object DecreaseReplicaCount
      extends Effect[
        DecreaseReplicaCountRequest,
        AwsError,
        zio.aws.elasticache.model.DecreaseReplicaCountResponse.ReadOnly
      ]
  object RebalanceSlotsInGlobalReplicationGroup
      extends Effect[
        RebalanceSlotsInGlobalReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse.ReadOnly
      ]
  object DescribeUpdateActions
      extends Stream[
        DescribeUpdateActionsRequest,
        AwsError,
        zio.aws.elasticache.model.UpdateAction.ReadOnly
      ]
  object DescribeUpdateActionsPaginated
      extends Effect[
        DescribeUpdateActionsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.elasticache.model.CreateUserResponse.ReadOnly
      ]
  object AuthorizeCacheSecurityGroupIngress
      extends Effect[
        AuthorizeCacheSecurityGroupIngressRequest,
        AwsError,
        zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse.ReadOnly
      ]
  object DeleteCacheSubnetGroup
      extends Effect[DeleteCacheSubnetGroupRequest, AwsError, Unit]
  object DeleteSnapshot
      extends Effect[
        DeleteSnapshotRequest,
        AwsError,
        zio.aws.elasticache.model.DeleteSnapshotResponse.ReadOnly
      ]
  object DescribeReplicationGroups
      extends Stream[
        DescribeReplicationGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.ReplicationGroup.ReadOnly
      ]
  object DescribeReplicationGroupsPaginated
      extends Effect[
        DescribeReplicationGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly
      ]
  object DescribeReservedCacheNodes
      extends Stream[
        DescribeReservedCacheNodesRequest,
        AwsError,
        zio.aws.elasticache.model.ReservedCacheNode.ReadOnly
      ]
  object DescribeReservedCacheNodesPaginated
      extends Effect[
        DescribeReservedCacheNodesRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly
      ]
  object DescribeServiceUpdates
      extends Stream[
        DescribeServiceUpdatesRequest,
        AwsError,
        zio.aws.elasticache.model.ServiceUpdate.ReadOnly
      ]
  object DescribeServiceUpdatesPaginated
      extends Effect[
        DescribeServiceUpdatesRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeServiceUpdatesResponse.ReadOnly
      ]
  object ModifyUserGroup
      extends Effect[
        ModifyUserGroupRequest,
        AwsError,
        zio.aws.elasticache.model.ModifyUserGroupResponse.ReadOnly
      ]
  object DescribeUsers
      extends Stream[
        DescribeUsersRequest,
        AwsError,
        zio.aws.elasticache.model.User.ReadOnly
      ]
  object DescribeUsersPaginated
      extends Effect[
        DescribeUsersRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeUsersResponse.ReadOnly
      ]
  object CreateCacheSecurityGroup
      extends Effect[
        CreateCacheSecurityGroupRequest,
        AwsError,
        zio.aws.elasticache.model.CreateCacheSecurityGroupResponse.ReadOnly
      ]
  object BatchApplyUpdateAction
      extends Effect[
        BatchApplyUpdateActionRequest,
        AwsError,
        zio.aws.elasticache.model.BatchApplyUpdateActionResponse.ReadOnly
      ]
  object CreateCacheCluster
      extends Effect[
        CreateCacheClusterRequest,
        AwsError,
        zio.aws.elasticache.model.CreateCacheClusterResponse.ReadOnly
      ]
  object DeleteCacheSecurityGroup
      extends Effect[DeleteCacheSecurityGroupRequest, AwsError, Unit]
  object DescribeGlobalReplicationGroups
      extends Stream[
        DescribeGlobalReplicationGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
      ]
  object DescribeGlobalReplicationGroupsPaginated
      extends Effect[
        DescribeGlobalReplicationGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse.ReadOnly
      ]
  object DisassociateGlobalReplicationGroup
      extends Effect[
        DisassociateGlobalReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.DisassociateGlobalReplicationGroupResponse.ReadOnly
      ]
  object DescribeReservedCacheNodesOfferings
      extends Stream[
        DescribeReservedCacheNodesOfferingsRequest,
        AwsError,
        zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly
      ]
  object DescribeReservedCacheNodesOfferingsPaginated
      extends Effect[
        DescribeReservedCacheNodesOfferingsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly
      ]
  object DescribeSnapshots
      extends Stream[
        DescribeSnapshotsRequest,
        AwsError,
        zio.aws.elasticache.model.Snapshot.ReadOnly
      ]
  object DescribeSnapshotsPaginated
      extends Effect[
        DescribeSnapshotsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeSnapshotsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.elasticache.model.ListTagsForResourceResponse.ReadOnly
      ]
  object RebootCacheCluster
      extends Effect[
        RebootCacheClusterRequest,
        AwsError,
        zio.aws.elasticache.model.RebootCacheClusterResponse.ReadOnly
      ]
  object DeleteUser
      extends Effect[
        DeleteUserRequest,
        AwsError,
        zio.aws.elasticache.model.DeleteUserResponse.ReadOnly
      ]
  object DeleteUserGroup
      extends Effect[
        DeleteUserGroupRequest,
        AwsError,
        zio.aws.elasticache.model.DeleteUserGroupResponse.ReadOnly
      ]
  object RevokeCacheSecurityGroupIngress
      extends Effect[
        RevokeCacheSecurityGroupIngressRequest,
        AwsError,
        zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse.ReadOnly
      ]
  object StartMigration
      extends Effect[
        StartMigrationRequest,
        AwsError,
        zio.aws.elasticache.model.StartMigrationResponse.ReadOnly
      ]
  object CreateCacheSubnetGroup
      extends Effect[
        CreateCacheSubnetGroupRequest,
        AwsError,
        zio.aws.elasticache.model.CreateCacheSubnetGroupResponse.ReadOnly
      ]
  object FailoverGlobalReplicationGroup
      extends Effect[
        FailoverGlobalReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse.ReadOnly
      ]
  object BatchStopUpdateAction
      extends Effect[BatchStopUpdateActionRequest, AwsError, ReadOnly]
  object DescribeCacheClusters
      extends Stream[
        DescribeCacheClustersRequest,
        AwsError,
        zio.aws.elasticache.model.CacheCluster.ReadOnly
      ]
  object DescribeCacheClustersPaginated
      extends Effect[
        DescribeCacheClustersRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeCacheClustersResponse.ReadOnly
      ]
  object CreateUserGroup
      extends Effect[
        CreateUserGroupRequest,
        AwsError,
        zio.aws.elasticache.model.CreateUserGroupResponse.ReadOnly
      ]
  object DescribeUserGroups
      extends Stream[
        DescribeUserGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.UserGroup.ReadOnly
      ]
  object DescribeUserGroupsPaginated
      extends Effect[
        DescribeUserGroupsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeUserGroupsResponse.ReadOnly
      ]
  object ModifyCacheParameterGroup
      extends Effect[
        ModifyCacheParameterGroupRequest,
        AwsError,
        zio.aws.elasticache.model.ModifyCacheParameterGroupResponse.ReadOnly
      ]
  object ModifyCacheCluster
      extends Effect[
        ModifyCacheClusterRequest,
        AwsError,
        zio.aws.elasticache.model.ModifyCacheClusterResponse.ReadOnly
      ]
  object TestFailover
      extends Effect[
        TestFailoverRequest,
        AwsError,
        zio.aws.elasticache.model.TestFailoverResponse.ReadOnly
      ]
  object ModifyGlobalReplicationGroup
      extends Effect[
        ModifyGlobalReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.ModifyGlobalReplicationGroupResponse.ReadOnly
      ]
  object DeleteCacheCluster
      extends Effect[
        DeleteCacheClusterRequest,
        AwsError,
        zio.aws.elasticache.model.DeleteCacheClusterResponse.ReadOnly
      ]
  object ModifyReplicationGroupShardConfiguration
      extends Effect[
        ModifyReplicationGroupShardConfigurationRequest,
        AwsError,
        zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse.ReadOnly
      ]
  object CreateSnapshot
      extends Effect[
        CreateSnapshotRequest,
        AwsError,
        zio.aws.elasticache.model.CreateSnapshotResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[
        DescribeEventsRequest,
        AwsError,
        zio.aws.elasticache.model.Event.ReadOnly
      ]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.elasticache.model.DescribeEventsResponse.ReadOnly
      ]
  object DecreaseNodeGroupsInGlobalReplicationGroup
      extends Effect[
        DecreaseNodeGroupsInGlobalReplicationGroupRequest,
        AwsError,
        zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ElastiCache] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ElastiCache {
          val api: ElastiCacheAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ElastiCache = this
          def describeEngineDefaultParameters(
              request: DescribeEngineDefaultParametersRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse.ReadOnly
          ] = proxy(DescribeEngineDefaultParameters, request)
          def describeCacheSecurityGroups(
              request: DescribeCacheSecurityGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeCacheSecurityGroups, request))
          def describeCacheSecurityGroupsPaginated(
              request: DescribeCacheSecurityGroupsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse.ReadOnly
          ] = proxy(DescribeCacheSecurityGroupsPaginated, request)
          def resetCacheParameterGroup(
              request: ResetCacheParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.ResetCacheParameterGroupResponse.ReadOnly
          ] = proxy(ResetCacheParameterGroup, request)
          def describeCacheParameters(
              request: DescribeCacheParametersRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.Parameter.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeCacheParameters, request))
          def describeCacheParametersPaginated(
              request: DescribeCacheParametersRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeCacheParametersResponse.ReadOnly
          ] = proxy(DescribeCacheParametersPaginated, request)
          def addTagsToResource(request: AddTagsToResourceRequest): IO[
            AwsError,
            zio.aws.elasticache.model.AddTagsToResourceResponse.ReadOnly
          ] = proxy(AddTagsToResource, request)
          def createCacheParameterGroup(
              request: CreateCacheParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.CreateCacheParameterGroupResponse.ReadOnly
          ] = proxy(CreateCacheParameterGroup, request)
          def createGlobalReplicationGroup(
              request: CreateGlobalReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.CreateGlobalReplicationGroupResponse.ReadOnly
          ] = proxy(CreateGlobalReplicationGroup, request)
          def deleteCacheParameterGroup(
              request: DeleteCacheParameterGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteCacheParameterGroup, request)
          def completeMigration(request: CompleteMigrationRequest): IO[
            AwsError,
            zio.aws.elasticache.model.CompleteMigrationResponse.ReadOnly
          ] = proxy(CompleteMigration, request)
          def deleteGlobalReplicationGroup(
              request: DeleteGlobalReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse.ReadOnly
          ] = proxy(DeleteGlobalReplicationGroup, request)
          def describeCacheParameterGroups(
              request: DescribeCacheParameterGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.CacheParameterGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeCacheParameterGroups, request))
          def describeCacheParameterGroupsPaginated(
              request: DescribeCacheParameterGroupsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeCacheParameterGroupsResponse.ReadOnly
          ] = proxy(DescribeCacheParameterGroupsPaginated, request)
          def increaseReplicaCount(request: IncreaseReplicaCountRequest): IO[
            AwsError,
            zio.aws.elasticache.model.IncreaseReplicaCountResponse.ReadOnly
          ] = proxy(IncreaseReplicaCount, request)
          def modifyUser(request: ModifyUserRequest): IO[
            AwsError,
            zio.aws.elasticache.model.ModifyUserResponse.ReadOnly
          ] = proxy(ModifyUser, request)
          def describeCacheEngineVersions(
              request: DescribeCacheEngineVersionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.CacheEngineVersion.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeCacheEngineVersions, request))
          def describeCacheEngineVersionsPaginated(
              request: DescribeCacheEngineVersionsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse.ReadOnly
          ] = proxy(DescribeCacheEngineVersionsPaginated, request)
          def listAllowedNodeTypeModifications(
              request: ListAllowedNodeTypeModificationsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.ListAllowedNodeTypeModificationsResponse.ReadOnly
          ] = proxy(ListAllowedNodeTypeModifications, request)
          def deleteReplicationGroup(
              request: DeleteReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DeleteReplicationGroupResponse.ReadOnly
          ] = proxy(DeleteReplicationGroup, request)
          def createReplicationGroup(
              request: CreateReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.CreateReplicationGroupResponse.ReadOnly
          ] = proxy(CreateReplicationGroup, request)
          def describeCacheSubnetGroups(
              request: DescribeCacheSubnetGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeCacheSubnetGroups, request))
          def describeCacheSubnetGroupsPaginated(
              request: DescribeCacheSubnetGroupsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly
          ] = proxy(DescribeCacheSubnetGroupsPaginated, request)
          def modifyCacheSubnetGroup(
              request: ModifyCacheSubnetGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse.ReadOnly
          ] = proxy(ModifyCacheSubnetGroup, request)
          def modifyReplicationGroup(
              request: ModifyReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.ModifyReplicationGroupResponse.ReadOnly
          ] = proxy(ModifyReplicationGroup, request)
          def copySnapshot(request: CopySnapshotRequest): IO[
            AwsError,
            zio.aws.elasticache.model.CopySnapshotResponse.ReadOnly
          ] = proxy(CopySnapshot, request)
          def purchaseReservedCacheNodesOffering(
              request: PurchaseReservedCacheNodesOfferingRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse.ReadOnly
          ] = proxy(PurchaseReservedCacheNodesOffering, request)
          def increaseNodeGroupsInGlobalReplicationGroup(
              request: IncreaseNodeGroupsInGlobalReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
          ] = proxy(IncreaseNodeGroupsInGlobalReplicationGroup, request)
          def removeTagsFromResource(
              request: RemoveTagsFromResourceRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.RemoveTagsFromResourceResponse.ReadOnly
          ] = proxy(RemoveTagsFromResource, request)
          def decreaseReplicaCount(request: DecreaseReplicaCountRequest): IO[
            AwsError,
            zio.aws.elasticache.model.DecreaseReplicaCountResponse.ReadOnly
          ] = proxy(DecreaseReplicaCount, request)
          def rebalanceSlotsInGlobalReplicationGroup(
              request: RebalanceSlotsInGlobalReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse.ReadOnly
          ] = proxy(RebalanceSlotsInGlobalReplicationGroup, request)
          def describeUpdateActions(
              request: DescribeUpdateActionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.UpdateAction.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeUpdateActions, request))
          def describeUpdateActionsPaginated(
              request: DescribeUpdateActionsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly
          ] = proxy(DescribeUpdateActionsPaginated, request)
          def createUser(request: CreateUserRequest): IO[
            AwsError,
            zio.aws.elasticache.model.CreateUserResponse.ReadOnly
          ] = proxy(CreateUser, request)
          def authorizeCacheSecurityGroupIngress(
              request: AuthorizeCacheSecurityGroupIngressRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse.ReadOnly
          ] = proxy(AuthorizeCacheSecurityGroupIngress, request)
          def deleteCacheSubnetGroup(
              request: DeleteCacheSubnetGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteCacheSubnetGroup, request)
          def deleteSnapshot(request: DeleteSnapshotRequest): IO[
            AwsError,
            zio.aws.elasticache.model.DeleteSnapshotResponse.ReadOnly
          ] = proxy(DeleteSnapshot, request)
          def describeReplicationGroups(
              request: DescribeReplicationGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.ReplicationGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeReplicationGroups, request))
          def describeReplicationGroupsPaginated(
              request: DescribeReplicationGroupsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly
          ] = proxy(DescribeReplicationGroupsPaginated, request)
          def describeReservedCacheNodes(
              request: DescribeReservedCacheNodesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.ReservedCacheNode.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeReservedCacheNodes, request))
          def describeReservedCacheNodesPaginated(
              request: DescribeReservedCacheNodesRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly
          ] = proxy(DescribeReservedCacheNodesPaginated, request)
          def describeServiceUpdates(
              request: DescribeServiceUpdatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.ServiceUpdate.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeServiceUpdates, request))
          def describeServiceUpdatesPaginated(
              request: DescribeServiceUpdatesRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeServiceUpdatesResponse.ReadOnly
          ] = proxy(DescribeServiceUpdatesPaginated, request)
          def modifyUserGroup(request: ModifyUserGroupRequest): IO[
            AwsError,
            zio.aws.elasticache.model.ModifyUserGroupResponse.ReadOnly
          ] = proxy(ModifyUserGroup, request)
          def describeUsers(
              request: DescribeUsersRequest
          ): ZStream[Any, AwsError, zio.aws.elasticache.model.User.ReadOnly] =
            rts.unsafeRun(proxy(DescribeUsers, request))
          def describeUsersPaginated(request: DescribeUsersRequest): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeUsersResponse.ReadOnly
          ] = proxy(DescribeUsersPaginated, request)
          def createCacheSecurityGroup(
              request: CreateCacheSecurityGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.CreateCacheSecurityGroupResponse.ReadOnly
          ] = proxy(CreateCacheSecurityGroup, request)
          def batchApplyUpdateAction(
              request: BatchApplyUpdateActionRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.BatchApplyUpdateActionResponse.ReadOnly
          ] = proxy(BatchApplyUpdateAction, request)
          def createCacheCluster(request: CreateCacheClusterRequest): IO[
            AwsError,
            zio.aws.elasticache.model.CreateCacheClusterResponse.ReadOnly
          ] = proxy(CreateCacheCluster, request)
          def deleteCacheSecurityGroup(
              request: DeleteCacheSecurityGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteCacheSecurityGroup, request)
          def describeGlobalReplicationGroups(
              request: DescribeGlobalReplicationGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeGlobalReplicationGroups, request))
          def describeGlobalReplicationGroupsPaginated(
              request: DescribeGlobalReplicationGroupsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeGlobalReplicationGroupsResponse.ReadOnly
          ] = proxy(DescribeGlobalReplicationGroupsPaginated, request)
          def disassociateGlobalReplicationGroup(
              request: DisassociateGlobalReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DisassociateGlobalReplicationGroupResponse.ReadOnly
          ] = proxy(DisassociateGlobalReplicationGroup, request)
          def describeReservedCacheNodesOfferings(
              request: DescribeReservedCacheNodesOfferingsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeReservedCacheNodesOfferings, request))
          def describeReservedCacheNodesOfferingsPaginated(
              request: DescribeReservedCacheNodesOfferingsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly
          ] = proxy(DescribeReservedCacheNodesOfferingsPaginated, request)
          def describeSnapshots(request: DescribeSnapshotsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.Snapshot.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeSnapshots, request))
          def describeSnapshotsPaginated(request: DescribeSnapshotsRequest): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeSnapshotsResponse.ReadOnly
          ] = proxy(DescribeSnapshotsPaginated, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.elasticache.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def rebootCacheCluster(request: RebootCacheClusterRequest): IO[
            AwsError,
            zio.aws.elasticache.model.RebootCacheClusterResponse.ReadOnly
          ] = proxy(RebootCacheCluster, request)
          def deleteUser(request: DeleteUserRequest): IO[
            AwsError,
            zio.aws.elasticache.model.DeleteUserResponse.ReadOnly
          ] = proxy(DeleteUser, request)
          def deleteUserGroup(request: DeleteUserGroupRequest): IO[
            AwsError,
            zio.aws.elasticache.model.DeleteUserGroupResponse.ReadOnly
          ] = proxy(DeleteUserGroup, request)
          def revokeCacheSecurityGroupIngress(
              request: RevokeCacheSecurityGroupIngressRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.RevokeCacheSecurityGroupIngressResponse.ReadOnly
          ] = proxy(RevokeCacheSecurityGroupIngress, request)
          def startMigration(request: StartMigrationRequest): IO[
            AwsError,
            zio.aws.elasticache.model.StartMigrationResponse.ReadOnly
          ] = proxy(StartMigration, request)
          def createCacheSubnetGroup(
              request: CreateCacheSubnetGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.CreateCacheSubnetGroupResponse.ReadOnly
          ] = proxy(CreateCacheSubnetGroup, request)
          def failoverGlobalReplicationGroup(
              request: FailoverGlobalReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.FailoverGlobalReplicationGroupResponse.ReadOnly
          ] = proxy(FailoverGlobalReplicationGroup, request)
          def batchStopUpdateAction(
              request: BatchStopUpdateActionRequest
          ): IO[AwsError, ReadOnly] = proxy(BatchStopUpdateAction, request)
          def describeCacheClusters(
              request: DescribeCacheClustersRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.CacheCluster.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeCacheClusters, request))
          def describeCacheClustersPaginated(
              request: DescribeCacheClustersRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeCacheClustersResponse.ReadOnly
          ] = proxy(DescribeCacheClustersPaginated, request)
          def createUserGroup(request: CreateUserGroupRequest): IO[
            AwsError,
            zio.aws.elasticache.model.CreateUserGroupResponse.ReadOnly
          ] = proxy(CreateUserGroup, request)
          def describeUserGroups(request: DescribeUserGroupsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.elasticache.model.UserGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeUserGroups, request))
          def describeUserGroupsPaginated(
              request: DescribeUserGroupsRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeUserGroupsResponse.ReadOnly
          ] = proxy(DescribeUserGroupsPaginated, request)
          def modifyCacheParameterGroup(
              request: ModifyCacheParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.ModifyCacheParameterGroupResponse.ReadOnly
          ] = proxy(ModifyCacheParameterGroup, request)
          def modifyCacheCluster(request: ModifyCacheClusterRequest): IO[
            AwsError,
            zio.aws.elasticache.model.ModifyCacheClusterResponse.ReadOnly
          ] = proxy(ModifyCacheCluster, request)
          def testFailover(request: TestFailoverRequest): IO[
            AwsError,
            zio.aws.elasticache.model.TestFailoverResponse.ReadOnly
          ] = proxy(TestFailover, request)
          def modifyGlobalReplicationGroup(
              request: ModifyGlobalReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.ModifyGlobalReplicationGroupResponse.ReadOnly
          ] = proxy(ModifyGlobalReplicationGroup, request)
          def deleteCacheCluster(request: DeleteCacheClusterRequest): IO[
            AwsError,
            zio.aws.elasticache.model.DeleteCacheClusterResponse.ReadOnly
          ] = proxy(DeleteCacheCluster, request)
          def modifyReplicationGroupShardConfiguration(
              request: ModifyReplicationGroupShardConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse.ReadOnly
          ] = proxy(ModifyReplicationGroupShardConfiguration, request)
          def createSnapshot(request: CreateSnapshotRequest): IO[
            AwsError,
            zio.aws.elasticache.model.CreateSnapshotResponse.ReadOnly
          ] = proxy(CreateSnapshot, request)
          def describeEvents(
              request: DescribeEventsRequest
          ): ZStream[Any, AwsError, zio.aws.elasticache.model.Event.ReadOnly] =
            rts.unsafeRun(proxy(DescribeEvents, request))
          def describeEventsPaginated(request: DescribeEventsRequest): IO[
            AwsError,
            zio.aws.elasticache.model.DescribeEventsResponse.ReadOnly
          ] = proxy(DescribeEventsPaginated, request)
          def decreaseNodeGroupsInGlobalReplicationGroup(
              request: DecreaseNodeGroupsInGlobalReplicationGroupRequest
          ): IO[
            AwsError,
            zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly
          ] = proxy(DecreaseNodeGroupsInGlobalReplicationGroup, request)
        }
      }
    }
    .toLayer
}
