package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PurchaseReservedCacheNodesOfferingRequest(
    reservedCacheNodesOfferingId: String,
    reservedCacheNodeId: Option[String] = None,
    cacheNodeCount: Option[IntegerOptional] = None,
    tags: Option[Iterable[zio.aws.elasticache.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest = {
    import PurchaseReservedCacheNodesOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest
      .builder()
      .reservedCacheNodesOfferingId(
        reservedCacheNodesOfferingId: java.lang.String
      )
      .optionallyWith(
        reservedCacheNodeId.map(value => value: java.lang.String)
      )(_.reservedCacheNodeId)
      .optionallyWith(cacheNodeCount.map(value => value: Integer))(
        _.cacheNodeCount
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingRequest.ReadOnly =
    zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingRequest
      .wrap(buildAwsValue())
}
object PurchaseReservedCacheNodesOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingRequest =
      zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingRequest(
        reservedCacheNodesOfferingId,
        reservedCacheNodeId.map(value => value),
        cacheNodeCount.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedCacheNodesOfferingId: String
    def reservedCacheNodeId: Option[String]
    def cacheNodeCount: Option[IntegerOptional]
    def tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def getReservedCacheNodesOfferingId: ZIO[Any, Nothing, String] =
      ZIO.succeed(reservedCacheNodesOfferingId)
    def getReservedCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedCacheNodeId", reservedCacheNodeId)
    def getCacheNodeCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("cacheNodeCount", cacheNodeCount)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest
  ) extends zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingRequest.ReadOnly {
    override val reservedCacheNodesOfferingId: String =
      impl.reservedCacheNodesOfferingId(): String
    override val reservedCacheNodeId: Option[String] =
      scala.Option(impl.reservedCacheNodeId()).map(value => value: String)
    override val cacheNodeCount: Option[IntegerOptional] =
      scala.Option(impl.cacheNodeCount()).map(value => value: IntegerOptional)
    override val tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest
  ): zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingRequest.ReadOnly =
    new Wrapper(impl)
}
