package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEngineDefaultParametersRequest(
    cacheParameterGroupFamily: String,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest = {
    import DescribeEngineDefaultParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest
      .builder()
      .cacheParameterGroupFamily(cacheParameterGroupFamily: java.lang.String)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest
      .wrap(buildAwsValue())
}
object DescribeEngineDefaultParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest =
      zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest(
        cacheParameterGroupFamily,
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def cacheParameterGroupFamily: String
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getCacheParameterGroupFamily: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheParameterGroupFamily)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest
  ) extends zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest.ReadOnly {
    override val cacheParameterGroupFamily: String =
      impl.cacheParameterGroupFamily(): String
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest
  ): zio.aws.elasticache.model.DescribeEngineDefaultParametersRequest.ReadOnly =
    new Wrapper(impl)
}
