package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCacheParameterGroupsRequest(
    cacheParameterGroupName: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest = {
    import DescribeCacheParameterGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest
      .builder()
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheParameterGroupsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheParameterGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeCacheParameterGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeCacheParameterGroupsRequest =
      zio.aws.elasticache.model.DescribeCacheParameterGroupsRequest(
        cacheParameterGroupName.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def cacheParameterGroupName: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest
  ) extends zio.aws.elasticache.model.DescribeCacheParameterGroupsRequest.ReadOnly {
    override val cacheParameterGroupName: Option[String] =
      scala.Option(impl.cacheParameterGroupName()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheParameterGroupsRequest
  ): zio.aws.elasticache.model.DescribeCacheParameterGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
