package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedCacheNodesResponse(
    marker: Option[String] = None,
    reservedCacheNodes: Option[
      Iterable[zio.aws.elasticache.model.ReservedCacheNode]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse = {
    import DescribeReservedCacheNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedCacheNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedCacheNodes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeReservedCacheNodesResponse
      .wrap(buildAwsValue())
}
object DescribeReservedCacheNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeReservedCacheNodesResponse =
      zio.aws.elasticache.model.DescribeReservedCacheNodesResponse(
        marker.map(value => value),
        reservedCacheNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def reservedCacheNodes
        : Option[List[zio.aws.elasticache.model.ReservedCacheNode.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedCacheNodes: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ReservedCacheNode.ReadOnly
    ]] = AwsError.unwrapOptionField("reservedCacheNodes", reservedCacheNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse
  ) extends zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val reservedCacheNodes
        : Option[List[zio.aws.elasticache.model.ReservedCacheNode.ReadOnly]] =
      scala
        .Option(impl.reservedCacheNodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.ReservedCacheNode.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesResponse
  ): zio.aws.elasticache.model.DescribeReservedCacheNodesResponse.ReadOnly =
    new Wrapper(impl)
}
