package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PendingLogDeliveryConfiguration(
    logType: Option[zio.aws.elasticache.model.LogType] = None,
    destinationType: Option[zio.aws.elasticache.model.DestinationType] = None,
    destinationDetails: Option[zio.aws.elasticache.model.DestinationDetails] =
      None,
    logFormat: Option[zio.aws.elasticache.model.LogFormat] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration = {
    import PendingLogDeliveryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration
      .builder()
      .optionallyWith(logType.map(value => value.unwrap))(_.logType)
      .optionallyWith(destinationType.map(value => value.unwrap))(
        _.destinationType
      )
      .optionallyWith(destinationDetails.map(value => value.buildAwsValue()))(
        _.destinationDetails
      )
      .optionallyWith(logFormat.map(value => value.unwrap))(_.logFormat)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly =
    zio.aws.elasticache.model.PendingLogDeliveryConfiguration
      .wrap(buildAwsValue())
}
object PendingLogDeliveryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.PendingLogDeliveryConfiguration =
      zio.aws.elasticache.model.PendingLogDeliveryConfiguration(
        logType.map(value => value),
        destinationType.map(value => value),
        destinationDetails.map(value => value.asEditable),
        logFormat.map(value => value)
      )
    def logType: Option[zio.aws.elasticache.model.LogType]
    def destinationType: Option[zio.aws.elasticache.model.DestinationType]
    def destinationDetails
        : Option[zio.aws.elasticache.model.DestinationDetails.ReadOnly]
    def logFormat: Option[zio.aws.elasticache.model.LogFormat]
    def getLogType: ZIO[Any, AwsError, zio.aws.elasticache.model.LogType] =
      AwsError.unwrapOptionField("logType", logType)
    def getDestinationType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.DestinationType] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getDestinationDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.DestinationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("destinationDetails", destinationDetails)
    def getLogFormat: ZIO[Any, AwsError, zio.aws.elasticache.model.LogFormat] =
      AwsError.unwrapOptionField("logFormat", logFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration
  ) extends zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly {
    override val logType: Option[zio.aws.elasticache.model.LogType] = scala
      .Option(impl.logType())
      .map(value => zio.aws.elasticache.model.LogType.wrap(value))
    override val destinationType
        : Option[zio.aws.elasticache.model.DestinationType] = scala
      .Option(impl.destinationType())
      .map(value => zio.aws.elasticache.model.DestinationType.wrap(value))
    override val destinationDetails
        : Option[zio.aws.elasticache.model.DestinationDetails.ReadOnly] = scala
      .Option(impl.destinationDetails())
      .map(value => zio.aws.elasticache.model.DestinationDetails.wrap(value))
    override val logFormat: Option[zio.aws.elasticache.model.LogFormat] = scala
      .Option(impl.logFormat())
      .map(value => zio.aws.elasticache.model.LogFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration
  ): zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly =
    new Wrapper(impl)
}
