package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCacheSecurityGroupResponse(
    cacheSecurityGroup: Option[zio.aws.elasticache.model.CacheSecurityGroup] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse = {
    import CreateCacheSecurityGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse
      .builder()
      .optionallyWith(cacheSecurityGroup.map(value => value.buildAwsValue()))(
        _.cacheSecurityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateCacheSecurityGroupResponse.ReadOnly =
    zio.aws.elasticache.model.CreateCacheSecurityGroupResponse
      .wrap(buildAwsValue())
}
object CreateCacheSecurityGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateCacheSecurityGroupResponse =
      zio.aws.elasticache.model.CreateCacheSecurityGroupResponse(
        cacheSecurityGroup.map(value => value.asEditable)
      )
    def cacheSecurityGroup
        : Option[zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly]
    def getCacheSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("cacheSecurityGroup", cacheSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse
  ) extends zio.aws.elasticache.model.CreateCacheSecurityGroupResponse.ReadOnly {
    override val cacheSecurityGroup
        : Option[zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly] = scala
      .Option(impl.cacheSecurityGroup())
      .map(value => zio.aws.elasticache.model.CacheSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupResponse
  ): zio.aws.elasticache.model.CreateCacheSecurityGroupResponse.ReadOnly =
    new Wrapper(impl)
}
