package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TimeRangeFilter(
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.TimeRangeFilter = {
    import TimeRangeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.TimeRangeFilter
      .builder()
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.TimeRangeFilter.ReadOnly =
    zio.aws.elasticache.model.TimeRangeFilter.wrap(buildAwsValue())
}
object TimeRangeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.TimeRangeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.TimeRangeFilter =
      zio.aws.elasticache.model.TimeRangeFilter(
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def startTime: Option[TStamp]
    def endTime: Option[TStamp]
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.TimeRangeFilter
  ) extends zio.aws.elasticache.model.TimeRangeFilter.ReadOnly {
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val endTime: Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.TimeRangeFilter
  ): zio.aws.elasticache.model.TimeRangeFilter.ReadOnly = new Wrapper(impl)
}
