package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUsersResponse(
    users: Option[Iterable[zio.aws.elasticache.model.User]] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse = {
    import DescribeUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DescribeUsersResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeUsersResponse.wrap(buildAwsValue())
}
object DescribeUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeUsersResponse =
      zio.aws.elasticache.model.DescribeUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def users: Option[List[zio.aws.elasticache.model.User.ReadOnly]]
    def marker: Option[String]
    def getUsers
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.User.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse
  ) extends zio.aws.elasticache.model.DescribeUsersResponse.ReadOnly {
    override val users: Option[List[zio.aws.elasticache.model.User.ReadOnly]] =
      scala
        .Option(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.User.wrap(item)
          }.toList
        )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUsersResponse
  ): zio.aws.elasticache.model.DescribeUsersResponse.ReadOnly = new Wrapper(
    impl
  )
}
