package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteSnapshotResponse(
    snapshot: Option[zio.aws.elasticache.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse = {
    import DeleteSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DeleteSnapshotResponse.ReadOnly =
    zio.aws.elasticache.model.DeleteSnapshotResponse.wrap(buildAwsValue())
}
object DeleteSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteSnapshotResponse =
      zio.aws.elasticache.model
        .DeleteSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Option[zio.aws.elasticache.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse
  ) extends zio.aws.elasticache.model.DeleteSnapshotResponse.ReadOnly {
    override val snapshot: Option[zio.aws.elasticache.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value => zio.aws.elasticache.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteSnapshotResponse
  ): zio.aws.elasticache.model.DeleteSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
