package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCacheClusterRequest(
    cacheClusterId: String,
    replicationGroupId: Option[String] = None,
    azMode: Option[zio.aws.elasticache.model.AZMode] = None,
    preferredAvailabilityZone: Option[String] = None,
    preferredAvailabilityZones: Option[Iterable[String]] = None,
    numCacheNodes: Option[IntegerOptional] = None,
    cacheNodeType: Option[String] = None,
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    cacheParameterGroupName: Option[String] = None,
    cacheSubnetGroupName: Option[String] = None,
    cacheSecurityGroupNames: Option[Iterable[String]] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    tags: Option[Iterable[zio.aws.elasticache.model.Tag]] = None,
    snapshotArns: Option[Iterable[String]] = None,
    snapshotName: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    port: Option[IntegerOptional] = None,
    notificationTopicArn: Option[String] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    snapshotWindow: Option[String] = None,
    authToken: Option[String] = None,
    outpostMode: Option[zio.aws.elasticache.model.OutpostMode] = None,
    preferredOutpostArn: Option[String] = None,
    preferredOutpostArns: Option[Iterable[String]] = None,
    logDeliveryConfigurations: Option[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfigurationRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest = {
    import CreateCacheClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest
      .builder()
      .cacheClusterId(cacheClusterId: java.lang.String)
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(azMode.map(value => value.unwrap))(_.azMode)
      .optionallyWith(
        preferredAvailabilityZone.map(value => value: java.lang.String)
      )(_.preferredAvailabilityZone)
      .optionallyWith(
        preferredAvailabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.preferredAvailabilityZones)
      .optionallyWith(
        numCacheNodes.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numCacheNodes)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(
        cacheSecurityGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheSecurityGroupNames)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        snapshotArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotArns)
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        snapshotRetentionLimit.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.snapshotRetentionLimit)
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(authToken.map(value => value: java.lang.String))(
        _.authToken
      )
      .optionallyWith(outpostMode.map(value => value.unwrap))(_.outpostMode)
      .optionallyWith(
        preferredOutpostArn.map(value => value: java.lang.String)
      )(_.preferredOutpostArn)
      .optionallyWith(
        preferredOutpostArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.preferredOutpostArns)
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CreateCacheClusterRequest.ReadOnly =
    zio.aws.elasticache.model.CreateCacheClusterRequest.wrap(buildAwsValue())
}
object CreateCacheClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateCacheClusterRequest =
      zio.aws.elasticache.model.CreateCacheClusterRequest(
        cacheClusterId,
        replicationGroupId.map(value => value),
        azMode.map(value => value),
        preferredAvailabilityZone.map(value => value),
        preferredAvailabilityZones.map(value => value),
        numCacheNodes.map(value => value),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        cacheParameterGroupName.map(value => value),
        cacheSubnetGroupName.map(value => value),
        cacheSecurityGroupNames.map(value => value),
        securityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshotArns.map(value => value),
        snapshotName.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        port.map(value => value),
        notificationTopicArn.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        authToken.map(value => value),
        outpostMode.map(value => value),
        preferredOutpostArn.map(value => value),
        preferredOutpostArns.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cacheClusterId: String
    def replicationGroupId: Option[String]
    def azMode: Option[zio.aws.elasticache.model.AZMode]
    def preferredAvailabilityZone: Option[String]
    def preferredAvailabilityZones: Option[List[String]]
    def numCacheNodes: Option[IntegerOptional]
    def cacheNodeType: Option[String]
    def engine: Option[String]
    def engineVersion: Option[String]
    def cacheParameterGroupName: Option[String]
    def cacheSubnetGroupName: Option[String]
    def cacheSecurityGroupNames: Option[List[String]]
    def securityGroupIds: Option[List[String]]
    def tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def snapshotArns: Option[List[String]]
    def snapshotName: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def port: Option[IntegerOptional]
    def notificationTopicArn: Option[String]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def snapshotWindow: Option[String]
    def authToken: Option[String]
    def outpostMode: Option[zio.aws.elasticache.model.OutpostMode]
    def preferredOutpostArn: Option[String]
    def preferredOutpostArns: Option[List[String]]
    def logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ]
    def getCacheClusterId: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheClusterId)
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getAzMode: ZIO[Any, AwsError, zio.aws.elasticache.model.AZMode] =
      AwsError.unwrapOptionField("azMode", azMode)
    def getPreferredAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredAvailabilityZone", preferredAvailabilityZone)
    def getPreferredAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "preferredAvailabilityZones",
        preferredAvailabilityZones
      )
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getCacheSecurityGroupNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("cacheSecurityGroupNames", cacheSecurityGroupNames)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSnapshotArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("snapshotArns", snapshotArns)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAuthToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authToken", authToken)
    def getOutpostMode
        : ZIO[Any, AwsError, zio.aws.elasticache.model.OutpostMode] =
      AwsError.unwrapOptionField("outpostMode", outpostMode)
    def getPreferredOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredOutpostArn", preferredOutpostArn)
    def getPreferredOutpostArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("preferredOutpostArns", preferredOutpostArns)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest
  ) extends zio.aws.elasticache.model.CreateCacheClusterRequest.ReadOnly {
    override val cacheClusterId: String = impl.cacheClusterId(): String
    override val replicationGroupId: Option[String] =
      scala.Option(impl.replicationGroupId()).map(value => value: String)
    override val azMode: Option[zio.aws.elasticache.model.AZMode] = scala
      .Option(impl.azMode())
      .map(value => zio.aws.elasticache.model.AZMode.wrap(value))
    override val preferredAvailabilityZone: Option[String] =
      scala.Option(impl.preferredAvailabilityZone()).map(value => value: String)
    override val preferredAvailabilityZones: Option[List[String]] = scala
      .Option(impl.preferredAvailabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val numCacheNodes: Option[IntegerOptional] = scala
      .Option(impl.numCacheNodes())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val cacheParameterGroupName: Option[String] =
      scala.Option(impl.cacheParameterGroupName()).map(value => value: String)
    override val cacheSubnetGroupName: Option[String] =
      scala.Option(impl.cacheSubnetGroupName()).map(value => value: String)
    override val cacheSecurityGroupNames: Option[List[String]] = scala
      .Option(impl.cacheSecurityGroupNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
    override val snapshotArns: Option[List[String]] = scala
      .Option(impl.snapshotArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotName: Option[String] =
      scala.Option(impl.snapshotName()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val notificationTopicArn: Option[String] =
      scala.Option(impl.notificationTopicArn()).map(value => value: String)
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val authToken: Option[String] =
      scala.Option(impl.authToken()).map(value => value: String)
    override val outpostMode: Option[zio.aws.elasticache.model.OutpostMode] =
      scala
        .Option(impl.outpostMode())
        .map(value => zio.aws.elasticache.model.OutpostMode.wrap(value))
    override val preferredOutpostArn: Option[String] =
      scala.Option(impl.preferredOutpostArn()).map(value => value: String)
    override val preferredOutpostArns: Option[List[String]] = scala
      .Option(impl.preferredOutpostArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ] = scala
      .Option(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfigurationRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheClusterRequest
  ): zio.aws.elasticache.model.CreateCacheClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
