package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UpdateAction(
    replicationGroupId: Option[String] = None,
    cacheClusterId: Option[String] = None,
    serviceUpdateName: Option[String] = None,
    serviceUpdateReleaseDate: Option[TStamp] = None,
    serviceUpdateSeverity: Option[
      zio.aws.elasticache.model.ServiceUpdateSeverity
    ] = None,
    serviceUpdateStatus: Option[zio.aws.elasticache.model.ServiceUpdateStatus] =
      None,
    serviceUpdateRecommendedApplyByDate: Option[TStamp] = None,
    serviceUpdateType: Option[zio.aws.elasticache.model.ServiceUpdateType] =
      None,
    updateActionAvailableDate: Option[TStamp] = None,
    updateActionStatus: Option[zio.aws.elasticache.model.UpdateActionStatus] =
      None,
    nodesUpdated: Option[String] = None,
    updateActionStatusModifiedDate: Option[TStamp] = None,
    slaMet: Option[zio.aws.elasticache.model.SlaMet] = None,
    nodeGroupUpdateStatus: Option[
      Iterable[zio.aws.elasticache.model.NodeGroupUpdateStatus]
    ] = None,
    cacheNodeUpdateStatus: Option[
      Iterable[zio.aws.elasticache.model.CacheNodeUpdateStatus]
    ] = None,
    estimatedUpdateTime: Option[String] = None,
    engine: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.UpdateAction = {
    import UpdateAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.UpdateAction
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        serviceUpdateReleaseDate.map(value => TStamp.unwrap(value): Instant)
      )(_.serviceUpdateReleaseDate)
      .optionallyWith(serviceUpdateSeverity.map(value => value.unwrap))(
        _.serviceUpdateSeverity
      )
      .optionallyWith(serviceUpdateStatus.map(value => value.unwrap))(
        _.serviceUpdateStatus
      )
      .optionallyWith(
        serviceUpdateRecommendedApplyByDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.serviceUpdateRecommendedApplyByDate)
      .optionallyWith(serviceUpdateType.map(value => value.unwrap))(
        _.serviceUpdateType
      )
      .optionallyWith(
        updateActionAvailableDate.map(value => TStamp.unwrap(value): Instant)
      )(_.updateActionAvailableDate)
      .optionallyWith(updateActionStatus.map(value => value.unwrap))(
        _.updateActionStatus
      )
      .optionallyWith(nodesUpdated.map(value => value: java.lang.String))(
        _.nodesUpdated
      )
      .optionallyWith(
        updateActionStatusModifiedDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.updateActionStatusModifiedDate)
      .optionallyWith(slaMet.map(value => value.unwrap))(_.slaMet)
      .optionallyWith(
        nodeGroupUpdateStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeGroupUpdateStatus)
      .optionallyWith(
        cacheNodeUpdateStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheNodeUpdateStatus)
      .optionallyWith(
        estimatedUpdateTime.map(value => value: java.lang.String)
      )(_.estimatedUpdateTime)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.UpdateAction.ReadOnly =
    zio.aws.elasticache.model.UpdateAction.wrap(buildAwsValue())
}
object UpdateAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.UpdateAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.UpdateAction =
      zio.aws.elasticache.model.UpdateAction(
        replicationGroupId.map(value => value),
        cacheClusterId.map(value => value),
        serviceUpdateName.map(value => value),
        serviceUpdateReleaseDate.map(value => value),
        serviceUpdateSeverity.map(value => value),
        serviceUpdateStatus.map(value => value),
        serviceUpdateRecommendedApplyByDate.map(value => value),
        serviceUpdateType.map(value => value),
        updateActionAvailableDate.map(value => value),
        updateActionStatus.map(value => value),
        nodesUpdated.map(value => value),
        updateActionStatusModifiedDate.map(value => value),
        slaMet.map(value => value),
        nodeGroupUpdateStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheNodeUpdateStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        estimatedUpdateTime.map(value => value),
        engine.map(value => value)
      )
    def replicationGroupId: Option[String]
    def cacheClusterId: Option[String]
    def serviceUpdateName: Option[String]
    def serviceUpdateReleaseDate: Option[TStamp]
    def serviceUpdateSeverity
        : Option[zio.aws.elasticache.model.ServiceUpdateSeverity]
    def serviceUpdateStatus
        : Option[zio.aws.elasticache.model.ServiceUpdateStatus]
    def serviceUpdateRecommendedApplyByDate: Option[TStamp]
    def serviceUpdateType: Option[zio.aws.elasticache.model.ServiceUpdateType]
    def updateActionAvailableDate: Option[TStamp]
    def updateActionStatus: Option[zio.aws.elasticache.model.UpdateActionStatus]
    def nodesUpdated: Option[String]
    def updateActionStatusModifiedDate: Option[TStamp]
    def slaMet: Option[zio.aws.elasticache.model.SlaMet]
    def nodeGroupUpdateStatus
        : Option[List[zio.aws.elasticache.model.NodeGroupUpdateStatus.ReadOnly]]
    def cacheNodeUpdateStatus
        : Option[List[zio.aws.elasticache.model.CacheNodeUpdateStatus.ReadOnly]]
    def estimatedUpdateTime: Option[String]
    def engine: Option[String]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getServiceUpdateReleaseDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("serviceUpdateReleaseDate", serviceUpdateReleaseDate)
    def getServiceUpdateSeverity
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateSeverity] =
      AwsError.unwrapOptionField("serviceUpdateSeverity", serviceUpdateSeverity)
    def getServiceUpdateStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateStatus] =
      AwsError.unwrapOptionField("serviceUpdateStatus", serviceUpdateStatus)
    def getServiceUpdateRecommendedApplyByDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "serviceUpdateRecommendedApplyByDate",
        serviceUpdateRecommendedApplyByDate
      )
    def getServiceUpdateType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateType] =
      AwsError.unwrapOptionField("serviceUpdateType", serviceUpdateType)
    def getUpdateActionAvailableDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("updateActionAvailableDate", updateActionAvailableDate)
    def getUpdateActionStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.UpdateActionStatus] =
      AwsError.unwrapOptionField("updateActionStatus", updateActionStatus)
    def getNodesUpdated: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodesUpdated", nodesUpdated)
    def getUpdateActionStatusModifiedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "updateActionStatusModifiedDate",
        updateActionStatusModifiedDate
      )
    def getSlaMet: ZIO[Any, AwsError, zio.aws.elasticache.model.SlaMet] =
      AwsError.unwrapOptionField("slaMet", slaMet)
    def getNodeGroupUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeGroupUpdateStatus.ReadOnly
    ]] =
      AwsError.unwrapOptionField("nodeGroupUpdateStatus", nodeGroupUpdateStatus)
    def getCacheNodeUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheNodeUpdateStatus.ReadOnly
    ]] =
      AwsError.unwrapOptionField("cacheNodeUpdateStatus", cacheNodeUpdateStatus)
    def getEstimatedUpdateTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("estimatedUpdateTime", estimatedUpdateTime)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.UpdateAction
  ) extends zio.aws.elasticache.model.UpdateAction.ReadOnly {
    override val replicationGroupId: Option[String] =
      scala.Option(impl.replicationGroupId()).map(value => value: String)
    override val cacheClusterId: Option[String] =
      scala.Option(impl.cacheClusterId()).map(value => value: String)
    override val serviceUpdateName: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override val serviceUpdateReleaseDate: Option[TStamp] = scala
      .Option(impl.serviceUpdateReleaseDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateSeverity
        : Option[zio.aws.elasticache.model.ServiceUpdateSeverity] = scala
      .Option(impl.serviceUpdateSeverity())
      .map(value => zio.aws.elasticache.model.ServiceUpdateSeverity.wrap(value))
    override val serviceUpdateStatus
        : Option[zio.aws.elasticache.model.ServiceUpdateStatus] = scala
      .Option(impl.serviceUpdateStatus())
      .map(value => zio.aws.elasticache.model.ServiceUpdateStatus.wrap(value))
    override val serviceUpdateRecommendedApplyByDate: Option[TStamp] = scala
      .Option(impl.serviceUpdateRecommendedApplyByDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateType
        : Option[zio.aws.elasticache.model.ServiceUpdateType] = scala
      .Option(impl.serviceUpdateType())
      .map(value => zio.aws.elasticache.model.ServiceUpdateType.wrap(value))
    override val updateActionAvailableDate: Option[TStamp] = scala
      .Option(impl.updateActionAvailableDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val updateActionStatus
        : Option[zio.aws.elasticache.model.UpdateActionStatus] = scala
      .Option(impl.updateActionStatus())
      .map(value => zio.aws.elasticache.model.UpdateActionStatus.wrap(value))
    override val nodesUpdated: Option[String] =
      scala.Option(impl.nodesUpdated()).map(value => value: String)
    override val updateActionStatusModifiedDate: Option[TStamp] = scala
      .Option(impl.updateActionStatusModifiedDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val slaMet: Option[zio.aws.elasticache.model.SlaMet] = scala
      .Option(impl.slaMet())
      .map(value => zio.aws.elasticache.model.SlaMet.wrap(value))
    override val nodeGroupUpdateStatus: Option[
      List[zio.aws.elasticache.model.NodeGroupUpdateStatus.ReadOnly]
    ] = scala
      .Option(impl.nodeGroupUpdateStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.NodeGroupUpdateStatus.wrap(item)
        }.toList
      )
    override val cacheNodeUpdateStatus: Option[
      List[zio.aws.elasticache.model.CacheNodeUpdateStatus.ReadOnly]
    ] = scala
      .Option(impl.cacheNodeUpdateStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheNodeUpdateStatus.wrap(item)
        }.toList
      )
    override val estimatedUpdateTime: Option[String] =
      scala.Option(impl.estimatedUpdateTime()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.UpdateAction
  ): zio.aws.elasticache.model.UpdateAction.ReadOnly = new Wrapper(impl)
}
