package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Event(
    sourceIdentifier: Option[String] = None,
    sourceType: Option[zio.aws.elasticache.model.SourceType] = None,
    message: Option[String] = None,
    date: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.Event
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(date.map(value => TStamp.unwrap(value): Instant))(_.date)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.Event.ReadOnly =
    zio.aws.elasticache.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.elasticache.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.Event =
      zio.aws.elasticache.model.Event(
        sourceIdentifier.map(value => value),
        sourceType.map(value => value),
        message.map(value => value),
        date.map(value => value)
      )
    def sourceIdentifier: Option[String]
    def sourceType: Option[zio.aws.elasticache.model.SourceType]
    def message: Option[String]
    def date: Option[TStamp]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("date", date)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.Event
  ) extends zio.aws.elasticache.model.Event.ReadOnly {
    override val sourceIdentifier: Option[String] =
      scala.Option(impl.sourceIdentifier()).map(value => value: String)
    override val sourceType: Option[zio.aws.elasticache.model.SourceType] =
      scala
        .Option(impl.sourceType())
        .map(value => zio.aws.elasticache.model.SourceType.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val date: Option[TStamp] = scala
      .Option(impl.date())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.Event
  ): zio.aws.elasticache.model.Event.ReadOnly = new Wrapper(impl)
}
