package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodeGroupMember(
    cacheClusterId: Option[String] = None,
    cacheNodeId: Option[String] = None,
    readEndpoint: Option[zio.aws.elasticache.model.Endpoint] = None,
    preferredAvailabilityZone: Option[String] = None,
    preferredOutpostArn: Option[String] = None,
    currentRole: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NodeGroupMember = {
    import NodeGroupMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NodeGroupMember
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(cacheNodeId.map(value => value: java.lang.String))(
        _.cacheNodeId
      )
      .optionallyWith(readEndpoint.map(value => value.buildAwsValue()))(
        _.readEndpoint
      )
      .optionallyWith(
        preferredAvailabilityZone.map(value => value: java.lang.String)
      )(_.preferredAvailabilityZone)
      .optionallyWith(
        preferredOutpostArn.map(value => value: java.lang.String)
      )(_.preferredOutpostArn)
      .optionallyWith(currentRole.map(value => value: java.lang.String))(
        _.currentRole
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.NodeGroupMember.ReadOnly =
    zio.aws.elasticache.model.NodeGroupMember.wrap(buildAwsValue())
}
object NodeGroupMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NodeGroupMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NodeGroupMember =
      zio.aws.elasticache.model.NodeGroupMember(
        cacheClusterId.map(value => value),
        cacheNodeId.map(value => value),
        readEndpoint.map(value => value.asEditable),
        preferredAvailabilityZone.map(value => value),
        preferredOutpostArn.map(value => value),
        currentRole.map(value => value)
      )
    def cacheClusterId: Option[String]
    def cacheNodeId: Option[String]
    def readEndpoint: Option[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def preferredAvailabilityZone: Option[String]
    def preferredOutpostArn: Option[String]
    def currentRole: Option[String]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeId", cacheNodeId)
    def getReadEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("readEndpoint", readEndpoint)
    def getPreferredAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredAvailabilityZone", preferredAvailabilityZone)
    def getPreferredOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredOutpostArn", preferredOutpostArn)
    def getCurrentRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentRole", currentRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupMember
  ) extends zio.aws.elasticache.model.NodeGroupMember.ReadOnly {
    override val cacheClusterId: Option[String] =
      scala.Option(impl.cacheClusterId()).map(value => value: String)
    override val cacheNodeId: Option[String] =
      scala.Option(impl.cacheNodeId()).map(value => value: String)
    override val readEndpoint
        : Option[zio.aws.elasticache.model.Endpoint.ReadOnly] = scala
      .Option(impl.readEndpoint())
      .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val preferredAvailabilityZone: Option[String] =
      scala.Option(impl.preferredAvailabilityZone()).map(value => value: String)
    override val preferredOutpostArn: Option[String] =
      scala.Option(impl.preferredOutpostArn()).map(value => value: String)
    override val currentRole: Option[String] =
      scala.Option(impl.currentRole()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupMember
  ): zio.aws.elasticache.model.NodeGroupMember.ReadOnly = new Wrapper(impl)
}
