package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AuthorizeCacheSecurityGroupIngressRequest(
    cacheSecurityGroupName: String,
    ec2SecurityGroupName: String,
    ec2SecurityGroupOwnerId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest = {
    import AuthorizeCacheSecurityGroupIngressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest
      .builder()
      .cacheSecurityGroupName(cacheSecurityGroupName: java.lang.String)
      .ec2SecurityGroupName(ec2SecurityGroupName: java.lang.String)
      .ec2SecurityGroupOwnerId(ec2SecurityGroupOwnerId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest.ReadOnly =
    zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest
      .wrap(buildAwsValue())
}
object AuthorizeCacheSecurityGroupIngressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest =
      zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest(
        cacheSecurityGroupName,
        ec2SecurityGroupName,
        ec2SecurityGroupOwnerId
      )
    def cacheSecurityGroupName: String
    def ec2SecurityGroupName: String
    def ec2SecurityGroupOwnerId: String
    def getCacheSecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheSecurityGroupName)
    def getEc2SecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(ec2SecurityGroupName)
    def getEc2SecurityGroupOwnerId: ZIO[Any, Nothing, String] =
      ZIO.succeed(ec2SecurityGroupOwnerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest
  ) extends zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest.ReadOnly {
    override val cacheSecurityGroupName: String =
      impl.cacheSecurityGroupName(): String
    override val ec2SecurityGroupName: String =
      impl.ec2SecurityGroupName(): String
    override val ec2SecurityGroupOwnerId: String =
      impl.ec2SecurityGroupOwnerId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest
  ): zio.aws.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest.ReadOnly =
    new Wrapper(impl)
}
